/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer;

import java.net.InetSocketAddress;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuditDataset;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuditStrategy;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.AbstractMllpInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.AuditInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.AuditInterceptorUtils;

public class ConsumerAuditInterceptor<T extends MllpAuditDataset>
extends AbstractMllpInterceptor<MllpTransactionEndpoint<T>>
implements AuditInterceptor<T> {
    public void process(Exchange exchange) throws Exception {
        AuditInterceptorUtils.doProcess(this, exchange);
    }

    @Override
    public MllpAuditStrategy<T> getAuditStrategy() {
        return ((MllpTransactionEndpoint)((Object)this.getMllpEndpoint())).getServerAuditStrategy();
    }

    @Override
    public void determineParticipantsAddresses(Exchange exchange, MllpAuditDataset auditDataset) throws Exception {
        Message message = exchange.getIn();
        auditDataset.setLocalAddress(ConsumerAuditInterceptor.addressFromHeader(message, "CamelMina2LocalAddress"));
        auditDataset.setRemoteAddress(ConsumerAuditInterceptor.addressFromHeader(message, "CamelMina2RemoteAddress"));
    }

    private static String addressFromHeader(Message message, String headerName) {
        InetSocketAddress address = (InetSocketAddress)message.getHeader(headerName);
        return address.getAddress().getHostAddress();
    }
}

