/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import org.apache.camel.Exchange;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.modules.hl7.message.MessageUtils;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.AuditUtils;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuditDataset;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuditStrategy;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.AuditInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuditInterceptorUtils {
    private static final transient Logger LOG = LoggerFactory.getLogger(AuditInterceptorUtils.class);

    private AuditInterceptorUtils() {
        throw new IllegalStateException("Helper class");
    }

    public static <T extends MllpAuditDataset> void doProcess(AuditInterceptor<T> interceptor, Exchange exchange) throws Exception {
        Message msg = (Message)exchange.getIn().getBody(Message.class);
        if (!AuditInterceptorUtils.isAuditable(interceptor, msg)) {
            interceptor.getWrappedProcessor().process(exchange);
            return;
        }
        MllpAuditStrategy<T> strategy = interceptor.getAuditStrategy();
        T auditDataset = AuditInterceptorUtils.createAndEnrichAuditDatasetFromRequest(strategy, exchange, msg);
        AuditInterceptorUtils.determineParticipantsAddresses(interceptor, exchange, auditDataset);
        boolean failed = false;
        try {
            try {
                interceptor.getWrappedProcessor().process(exchange);
                Message result = (Message)Exchanges.resultMessage((Exchange)exchange).getBody(Message.class);
                AuditInterceptorUtils.enrichAuditDatasetFromResponse(strategy, auditDataset, msg);
                failed = !AuditUtils.isPositiveAck(result);
            }
            catch (Exception e) {
                failed = true;
                throw e;
            }
        }
        finally {
            AuditUtils.finalizeAudit(auditDataset, strategy, failed);
        }
    }

    private static <T extends MllpAuditDataset> boolean isAuditable(AuditInterceptor<T> interceptor, Message message) {
        block3: {
            try {
                Terser terser = new Terser(message);
                if (!ArrayUtils.contains((Object[])message.getNames(), (Object)"DSC") || !StringUtils.isNotEmpty((CharSequence)terser.get("DSC-1"))) break block3;
                return false;
            }
            catch (Exception e) {
                LOG.error("Exception when determining message auditability, no audit will be performed", (Throwable)e);
                return false;
            }
        }
        return ((MllpEndpoint)((Object)interceptor.getMllpEndpoint())).getHl7v2TransactionConfiguration().isAuditable(MessageUtils.eventType((Message)message));
    }

    private static <T extends MllpAuditDataset> T createAndEnrichAuditDatasetFromRequest(MllpAuditStrategy<T> strategy, Exchange exchange, Message msg) {
        try {
            T auditDataset = strategy.createAuditDataset();
            AuditUtils.enrichGenericAuditDatasetFromRequest(auditDataset, msg);
            strategy.enrichAuditDatasetFromRequest(auditDataset, msg, exchange);
            return auditDataset;
        }
        catch (Exception e) {
            LOG.error("Exception when enriching audit dataset from request", (Throwable)e);
            return null;
        }
    }

    private static <T extends MllpAuditDataset> void enrichAuditDatasetFromResponse(MllpAuditStrategy<T> strategy, T auditDataset, Message msg) {
        try {
            strategy.enrichAuditDatasetFromResponse(auditDataset, msg);
        }
        catch (Exception e) {
            LOG.error("Exception when enriching audit dataset from response", (Throwable)e);
        }
    }

    private static <T extends MllpAuditDataset> void determineParticipantsAddresses(AuditInterceptor<T> interceptor, Exchange exchange, T auditDataset) {
        try {
            interceptor.determineParticipantsAddresses(exchange, auditDataset);
        }
        catch (Exception e) {
            LOG.error("Exception when determining participants' addresses", (Throwable)e);
        }
    }
}

