/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.component.mina2.Mina2Endpoint;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.Hl7v2Interceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.consumer.ConsumerAdaptingInterceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.consumer.ConsumerMarshalInterceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.consumer.ConsumerRequestAcceptanceInterceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.consumer.ConsumerResponseAcceptanceInterceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.producer.ProducerAdaptingInterceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.producer.ProducerMarshalInterceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.producer.ProducerRequestAcceptanceInterceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.producer.ProducerResponseAcceptanceInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.InteractiveContinuationStorage;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuditDataset;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuditStrategy;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.UnsolicitedFragmentationStorage;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerAuditInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerAuthenticationFailureInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerInteractiveResponseSenderInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerRequestDefragmenterInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerStringProcessingInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.producer.ProducerAuditInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.producer.ProducerMarshalAndInteractiveResponseReceiverInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.producer.ProducerRequestFragmenterInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.producer.ProducerStringProcessingInterceptor;

public class MllpTransactionEndpoint<AuditDatasetType extends MllpAuditDataset>
extends MllpEndpoint<MllpTransactionEndpointConfiguration, MllpTransactionComponent<AuditDatasetType>> {
    public MllpTransactionEndpoint(MllpTransactionComponent<AuditDatasetType> mllpComponent, Mina2Endpoint wrappedEndpoint, MllpTransactionEndpointConfiguration config) {
        super(mllpComponent, wrappedEndpoint, config);
    }

    @Override
    protected List<Hl7v2Interceptor> createInitialConsumerInterceptorChain() {
        ArrayList<Hl7v2Interceptor> initialChain = new ArrayList<Hl7v2Interceptor>();
        initialChain.add(new ConsumerStringProcessingInterceptor());
        if (this.isSupportUnsolicitedFragmentation()) {
            initialChain.add(new ConsumerRequestDefragmenterInterceptor());
        }
        initialChain.add((Hl7v2Interceptor)new ConsumerMarshalInterceptor());
        initialChain.add((Hl7v2Interceptor)new ConsumerRequestAcceptanceInterceptor());
        if (this.isSupportInteractiveContinuation()) {
            initialChain.add(new ConsumerInteractiveResponseSenderInterceptor());
        }
        if (this.isAudit()) {
            initialChain.add(new ConsumerAuditInterceptor());
        }
        initialChain.add((Hl7v2Interceptor)new ConsumerResponseAcceptanceInterceptor());
        initialChain.add((Hl7v2Interceptor)new ConsumerAdaptingInterceptor(this.getCharsetName()));
        if (this.isAudit()) {
            initialChain.add(new ConsumerAuthenticationFailureInterceptor());
        }
        return initialChain;
    }

    @Override
    protected List<Hl7v2Interceptor> createInitialProducerInterceptorChain() {
        ArrayList<Hl7v2Interceptor> initialChain = new ArrayList<Hl7v2Interceptor>();
        initialChain.add(new ProducerStringProcessingInterceptor());
        if (this.isSupportUnsolicitedFragmentation()) {
            initialChain.add(new ProducerRequestFragmenterInterceptor());
        }
        initialChain.add(this.isSupportInteractiveContinuation() ? new ProducerMarshalAndInteractiveResponseReceiverInterceptor() : new ProducerMarshalInterceptor());
        initialChain.add((Hl7v2Interceptor)new ProducerResponseAcceptanceInterceptor());
        if (this.isAudit()) {
            initialChain.add(new ProducerAuditInterceptor());
        }
        initialChain.add((Hl7v2Interceptor)new ProducerRequestAcceptanceInterceptor());
        initialChain.add((Hl7v2Interceptor)new ProducerAdaptingInterceptor());
        return initialChain;
    }

    @ManagedAttribute(description="Audit Enabled")
    public boolean isAudit() {
        return ((MllpTransactionEndpointConfiguration)this.getConfig()).isAudit();
    }

    public MllpAuditStrategy<AuditDatasetType> getClientAuditStrategy() {
        return ((MllpTransactionComponent)((Object)this.getMllpComponent())).getClientAuditStrategy();
    }

    public MllpAuditStrategy<AuditDatasetType> getServerAuditStrategy() {
        return ((MllpTransactionComponent)((Object)this.getMllpComponent())).getServerAuditStrategy();
    }

    @ManagedAttribute(description="Support Unsolicited Fragmentation Enabled")
    public boolean isSupportUnsolicitedFragmentation() {
        return ((MllpTransactionEndpointConfiguration)this.getConfig()).isSupportUnsolicitedFragmentation();
    }

    @ManagedAttribute(description="Unsolicited Fragmentation Threshold")
    public int getUnsolicitedFragmentationThreshold() {
        return ((MllpTransactionEndpointConfiguration)this.getConfig()).getUnsolicitedFragmentationThreshold();
    }

    public UnsolicitedFragmentationStorage getUnsolicitedFragmentationStorage() {
        return ((MllpTransactionEndpointConfiguration)this.getConfig()).getUnsolicitedFragmentationStorage();
    }

    @ManagedAttribute(description="Unsolicited Fragmentation Storage Cache Type")
    public String getUnsolicitedFragmentationStorageType() {
        return this.isSupportUnsolicitedFragmentation() ? this.getUnsolicitedFragmentationStorage().getClass().getName() : "";
    }

    @ManagedAttribute(description="Support Interactive Continuation Enabled")
    public boolean isSupportInteractiveContinuation() {
        return ((MllpTransactionEndpointConfiguration)this.getConfig()).isSupportInteractiveContinuation();
    }

    @ManagedAttribute(description="Interactive Continuation Default Threshold")
    public int getInteractiveContinuationDefaultThreshold() {
        return ((MllpTransactionEndpointConfiguration)this.getConfig()).getInteractiveContinuationDefaultThreshold();
    }

    public InteractiveContinuationStorage getInteractiveContinuationStorage() {
        return ((MllpTransactionEndpointConfiguration)this.getConfig()).getInteractiveContinuationStorage();
    }

    @ManagedAttribute(description="Auto Cancel Enabled")
    public boolean isAutoCancel() {
        return ((MllpTransactionEndpointConfiguration)this.getConfig()).isAutoCancel();
    }

    @ManagedAttribute(description="Interactive Continuation Storage Cache Type")
    public String getInteractiveContinuationStorageType() {
        return this.isSupportInteractiveContinuation() ? this.getInteractiveContinuationStorage().getClass().getName() : "";
    }
}

