/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.camel.spring.GenericBeansException;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.openehealth.ipf.commons.ihe.core.ClientAuthType;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.Hl7v2InterceptorFactory;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerDispatchingInterceptor;
import org.springframework.context.ApplicationContext;

public class MllpEndpointConfiguration
implements Serializable {
    private static final long serialVersionUID = -3604219045768985192L;
    private final ProtocolCodecFactory codecFactory;
    private final boolean audit;
    private final SSLContext sslContext;
    private final String[] customInterceptorBeans;
    private final List<Hl7v2InterceptorFactory> customInterceptorFactories;
    private final ClientAuthType clientAuthType;
    private final String[] sslProtocols;
    private final String[] sslCiphers;
    private final boolean supportSegmentFragmentation;
    private final int segmentFragmentationThreshold;
    private ConsumerDispatchingInterceptor dispatcher;

    protected MllpEndpointConfiguration(MllpComponent component, Map<String, Object> parameters) throws Exception {
        this.codecFactory = (ProtocolCodecFactory)component.getCamelContext().getRegistry().lookupByNameAndType(MllpEndpointConfiguration.extractBeanName((String)parameters.get("codec")), ProtocolCodecFactory.class);
        this.audit = (Boolean)component.getAndRemoveParameter(parameters, "audit", Boolean.TYPE, true);
        this.clientAuthType = (ClientAuthType)component.getAndRemoveParameter(parameters, "clientAuth", ClientAuthType.class, ClientAuthType.NONE);
        String sslProtocolsString = (String)component.getAndRemoveParameter(parameters, "sslProtocols", String.class, null);
        String sslCiphersString = (String)component.getAndRemoveParameter(parameters, "sslCiphers", String.class, null);
        this.sslProtocols = sslProtocolsString != null ? sslProtocolsString.split(",") : null;
        this.sslCiphers = sslCiphersString != null ? sslCiphersString.split(",") : null;
        boolean secure = (Boolean)component.getAndRemoveParameter(parameters, "secure", Boolean.TYPE, false);
        this.sslContext = secure ? (SSLContext)component.resolveAndRemoveReferenceParameter(parameters, "sslContext", SSLContext.class, SSLContext.getDefault()) : null;
        this.supportSegmentFragmentation = (Boolean)component.getAndRemoveParameter(parameters, "supportSegmentFragmentation", Boolean.TYPE, false);
        this.segmentFragmentationThreshold = (Integer)component.getAndRemoveParameter(parameters, "segmentFragmentationThreshold", Integer.TYPE, -1);
        this.customInterceptorFactories = component.resolveAndRemoveReferenceListParameter(parameters, "interceptorFactories", Hl7v2InterceptorFactory.class);
        this.customInterceptorBeans = this.extractInterceptorBeanNames(component, parameters);
        this.dispatcher = (ConsumerDispatchingInterceptor)component.resolveAndRemoveReferenceParameter(parameters, "dispatcher", ConsumerDispatchingInterceptor.class);
    }

    private static String extractBeanName(String originalBeanName) {
        return originalBeanName.startsWith("#") ? originalBeanName.substring(1) : originalBeanName;
    }

    private String[] extractInterceptorBeanNames(MllpComponent component, Map<String, Object> parameters) {
        SpringCamelContext camelContext = (SpringCamelContext)component.getCamelContext();
        ApplicationContext applicationContext = camelContext.getApplicationContext();
        String paramValue = (String)component.getAndRemoveParameter(parameters, "interceptors", String.class);
        if (StringUtils.isEmpty((CharSequence)paramValue)) {
            return new String[0];
        }
        String[] beanNames = paramValue.split(",");
        int i = 0;
        while (i < beanNames.length) {
            beanNames[i] = MllpEndpointConfiguration.extractBeanName(beanNames[i]);
            if (!applicationContext.isPrototype(beanNames[i])) {
                throw new GenericBeansException("Custom HL7v2 interceptor bean '" + beanNames[i] + "' shall have scope=\"prototype\"");
            }
            ++i;
        }
        return beanNames;
    }

    public ProtocolCodecFactory getCodecFactory() {
        return this.codecFactory;
    }

    public boolean isAudit() {
        return this.audit;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public String[] getCustomInterceptorBeans() {
        return this.customInterceptorBeans;
    }

    public List<Hl7v2InterceptorFactory> getCustomInterceptorFactories() {
        return this.customInterceptorFactories;
    }

    public ClientAuthType getClientAuthType() {
        return this.clientAuthType;
    }

    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    public String[] getSslCiphers() {
        return this.sslCiphers;
    }

    public boolean isSupportSegmentFragmentation() {
        return this.supportSegmentFragmentation;
    }

    public int getSegmentFragmentationThreshold() {
        return this.segmentFragmentationThreshold;
    }

    public ConsumerDispatchingInterceptor getDispatcher() {
        return this.dispatcher;
    }
}

