/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.mina2.Mina2Configuration;
import org.apache.camel.component.mina2.Mina2Consumer;
import org.apache.camel.component.mina2.Mina2Endpoint;
import org.apache.camel.component.mina2.Mina2Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.commons.lang3.Validate;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.openehealth.ipf.commons.ihe.core.ClientAuthType;
import org.openehealth.ipf.commons.ihe.core.chain.ChainUtils;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2ConfigurationHolder;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.NakFactory;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.Hl7v2Interceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.Hl7v2InterceptorFactory;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.Hl7v2InterceptorUtils;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.HandshakeCallbackSSLFilter;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuditStrategy;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerDispatchingInterceptor;

@ManagedResource(description="Managed IPF MLLP ITI Endpoint")
public abstract class MllpEndpoint<ConfigType extends MllpEndpointConfiguration, ComponentType extends MllpComponent<ConfigType>>
extends DefaultEndpoint
implements Hl7v2ConfigurationHolder {
    private final ConfigType config;
    private final ComponentType mllpComponent;
    private final Mina2Endpoint wrappedEndpoint;

    public MllpEndpoint(ComponentType mllpComponent, Mina2Endpoint wrappedEndpoint, ConfigType config) {
        this.mllpComponent = (MllpComponent)((Object)Validate.notNull(mllpComponent));
        this.wrappedEndpoint = (Mina2Endpoint)Validate.notNull((Object)wrappedEndpoint);
        this.config = (MllpEndpointConfiguration)Validate.notNull(config);
    }

    private synchronized List<Hl7v2Interceptor> getCustomInterceptors() {
        ArrayList<Hl7v2Interceptor> result = new ArrayList<Hl7v2Interceptor>();
        String[] stringArray = ((MllpEndpointConfiguration)this.config).getCustomInterceptorBeans();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            result.add((Hl7v2Interceptor)this.getCamelContext().getRegistry().lookupByNameAndType(beanName, Hl7v2Interceptor.class));
            ++n2;
        }
        for (Hl7v2InterceptorFactory customInterceptorFactory : ((MllpEndpointConfiguration)this.config).getCustomInterceptorFactories()) {
            result.add(customInterceptorFactory.getNewInstance());
        }
        return result;
    }

    protected abstract List<Hl7v2Interceptor> createInitialConsumerInterceptorChain();

    protected abstract List<Hl7v2Interceptor> createInitialProducerInterceptorChain();

    private List<Hl7v2Interceptor> getConsumerInterceptorChain() {
        List<Hl7v2Interceptor> initialChain = this.createInitialConsumerInterceptorChain();
        ArrayList<Hl7v2Interceptor> additionalInterceptors = new ArrayList<Hl7v2Interceptor>();
        additionalInterceptors.addAll(((MllpComponent)((Object)this.mllpComponent)).getAdditionalConsumerInterceptors());
        additionalInterceptors.addAll(this.getCustomInterceptors());
        return ChainUtils.createChain(initialChain, additionalInterceptors);
    }

    private List<Hl7v2Interceptor> getProducerInterceptorChain() {
        List<Hl7v2Interceptor> initialChain = this.createInitialProducerInterceptorChain();
        ArrayList<Hl7v2Interceptor> additionalInterceptors = new ArrayList<Hl7v2Interceptor>();
        additionalInterceptors.addAll(((MllpComponent)((Object)this.mllpComponent)).getAdditionalProducerInterceptors());
        additionalInterceptors.addAll(this.getCustomInterceptors());
        return ChainUtils.createChain(initialChain, additionalInterceptors);
    }

    public Consumer createConsumer(Processor originalProcessor) throws Exception {
        DefaultIoFilterChainBuilder filterChain;
        List<Hl7v2Interceptor> chain = this.getConsumerInterceptorChain();
        Processor processor = originalProcessor;
        int i = chain.size() - 1;
        while (i >= 0) {
            Hl7v2Interceptor interceptor = chain.get(i);
            interceptor.setConfigurationHolder((Hl7v2ConfigurationHolder)this);
            interceptor.setWrappedProcessor(processor);
            processor = interceptor;
            --i;
        }
        Mina2Consumer consumer = (Mina2Consumer)this.wrappedEndpoint.createConsumer(processor);
        if (((MllpEndpointConfiguration)this.config).getSslContext() != null && !(filterChain = consumer.getAcceptor().getFilterChain()).contains("ssl")) {
            HandshakeCallbackSSLFilter filter = new HandshakeCallbackSSLFilter(((MllpEndpointConfiguration)this.config).getSslContext());
            filter.setNeedClientAuth(((MllpEndpointConfiguration)this.config).getClientAuthType() == ClientAuthType.MUST);
            filter.setWantClientAuth(((MllpEndpointConfiguration)this.config).getClientAuthType() == ClientAuthType.WANT);
            filter.setHandshakeExceptionCallback(new HandshakeFailureCallback());
            filter.setEnabledProtocols(((MllpEndpointConfiguration)this.config).getSslProtocols());
            filter.setEnabledCipherSuites(((MllpEndpointConfiguration)this.config).getSslCiphers());
            filterChain.addFirst("ssl", (IoFilter)filter);
        }
        return consumer;
    }

    public Producer createProducer() throws Exception {
        DefaultIoFilterChainBuilder filterChain;
        Mina2Producer producer = (Mina2Producer)this.wrappedEndpoint.createProducer();
        if (((MllpEndpointConfiguration)this.config).getSslContext() != null && !(filterChain = producer.getFilterChain()).contains("ssl")) {
            HandshakeCallbackSSLFilter filter = new HandshakeCallbackSSLFilter(((MllpEndpointConfiguration)this.config).getSslContext());
            filter.setUseClientMode(true);
            filter.setHandshakeExceptionCallback(new HandshakeFailureCallback());
            filter.setEnabledProtocols(((MllpEndpointConfiguration)this.config).getSslProtocols());
            filter.setEnabledCipherSuites(((MllpEndpointConfiguration)this.config).getSslCiphers());
            filterChain.addFirst("ssl", (IoFilter)filter);
        }
        return Hl7v2InterceptorUtils.adaptProducerChain(this.getProducerInterceptorChain(), (Hl7v2ConfigurationHolder)this, (Producer)producer);
    }

    public Hl7v2TransactionConfiguration getHl7v2TransactionConfiguration() {
        return this.mllpComponent.getHl7v2TransactionConfiguration();
    }

    public NakFactory getNakFactory() {
        return this.mllpComponent.getNakFactory();
    }

    @ManagedAttribute(description="Support Segment Fragmentation Enabled")
    public boolean isSupportSegmentFragmentation() {
        return ((MllpEndpointConfiguration)this.config).isSupportSegmentFragmentation();
    }

    @ManagedAttribute(description="Segment Fragmentation Threshold")
    public int getSegmentFragmentationThreshold() {
        return ((MllpEndpointConfiguration)this.config).getSegmentFragmentationThreshold();
    }

    public SSLContext getSslContext() {
        return ((MllpEndpointConfiguration)this.config).getSslContext();
    }

    @ManagedAttribute(description="Defined SSL Protocols")
    public String[] getSslProtocols() {
        return ((MllpEndpointConfiguration)this.config).getSslProtocols();
    }

    @ManagedAttribute(description="Defined SSL Ciphers")
    public String[] getSslCiphers() {
        return ((MllpEndpointConfiguration)this.config).getSslCiphers();
    }

    @ManagedAttribute(description="Component Type Name")
    public String getComponentType() {
        return this.getComponent().getClass().getName();
    }

    @ManagedAttribute(description="Mina Host")
    public String getHost() {
        return this.getConfiguration().getHost();
    }

    @ManagedAttribute(description="Mina Port")
    public int getPort() {
        return this.getConfiguration().getPort();
    }

    @ManagedAttribute(description="Mina Character Set")
    public String getCharsetName() {
        return this.getConfiguration().getCharsetName();
    }

    @ManagedAttribute(description="Mina Timeout")
    public long getTimeout() {
        return this.getConfiguration().getTimeout();
    }

    @ManagedAttribute(description="Mina Filters")
    public String[] getIoFilters() {
        List filters = this.getConfiguration().getFilters();
        return this.toStringArray(filters);
    }

    @ManagedAttribute(description="SSL Secure Enabled")
    public boolean isSslSecure() {
        return this.getSslContext() != null;
    }

    public ClientAuthType getClientAuthType() {
        return ((MllpEndpointConfiguration)this.config).getClientAuthType();
    }

    @ManagedAttribute(description="Client Authentication Type")
    public String getClientAuthTypeClass() {
        return this.getClientAuthType().toString();
    }

    @ManagedAttribute(description="Custom Interceptor Beans")
    public String[] getCustomInterceptorBeans() {
        return ((MllpEndpointConfiguration)this.config).getCustomInterceptorBeans();
    }

    public List<Hl7v2InterceptorFactory> getCustomInterceptorFactories() {
        return ((MllpEndpointConfiguration)this.config).getCustomInterceptorFactories();
    }

    public ConsumerDispatchingInterceptor getDispatcher() {
        return ((MllpEndpointConfiguration)this.config).getDispatcher();
    }

    @ManagedAttribute(description="Custom Interceptor Factories")
    public String[] getCustomInterceptorFactoryList() {
        return this.toStringArray(this.getCustomInterceptorFactories());
    }

    private String[] toStringArray(List<?> list) {
        String[] result = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            result[i] = list.get(i).getClass().getCanonicalName();
            ++i;
        }
        return result;
    }

    public void configureProperties(Map options) {
        this.wrappedEndpoint.configureProperties(options);
    }

    public Exchange createExchange() {
        return this.wrappedEndpoint.createExchange();
    }

    public Exchange createExchange(Exchange exchange) {
        return this.wrappedEndpoint.createExchange(exchange);
    }

    public Exchange createExchange(ExchangePattern pattern) {
        return this.wrappedEndpoint.createExchange(pattern);
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        return this.wrappedEndpoint.createPollingConsumer();
    }

    public boolean equals(Object object) {
        if (object instanceof MllpEndpoint) {
            MllpEndpoint that = (MllpEndpoint)((Object)object);
            return this.wrappedEndpoint.equals((Object)that.getWrappedEndpoint());
        }
        return false;
    }

    public CamelContext getCamelContext() {
        return this.wrappedEndpoint.getCamelContext();
    }

    public Component getComponent() {
        return this.wrappedEndpoint.getComponent();
    }

    public Mina2Configuration getConfiguration() {
        return this.wrappedEndpoint.getConfiguration();
    }

    public String getEndpointKey() {
        return this.wrappedEndpoint.getEndpointKey();
    }

    public String getEndpointUri() {
        return this.wrappedEndpoint.getEndpointUri();
    }

    public ExchangePattern getExchangePattern() {
        return this.wrappedEndpoint.getExchangePattern();
    }

    public int hashCode() {
        return this.wrappedEndpoint.hashCode();
    }

    public boolean isLenientProperties() {
        return this.wrappedEndpoint.isLenientProperties();
    }

    public boolean isSingleton() {
        return this.wrappedEndpoint.isSingleton();
    }

    public void setCamelContext(CamelContext camelContext) {
        this.wrappedEndpoint.setCamelContext(camelContext);
    }

    public void setEndpointUriIfNotSpecified(String value) {
        this.wrappedEndpoint.setEndpointUriIfNotSpecified(value);
    }

    public void setExchangePattern(ExchangePattern exchangePattern) {
        this.wrappedEndpoint.setExchangePattern(exchangePattern);
    }

    public String toString() {
        return this.wrappedEndpoint.toString();
    }

    protected ConfigType getConfig() {
        return this.config;
    }

    protected ComponentType getMllpComponent() {
        return this.mllpComponent;
    }

    protected Mina2Endpoint getWrappedEndpoint() {
        return this.wrappedEndpoint;
    }

    private class HandshakeFailureCallback
    implements HandshakeCallbackSSLFilter.Callback {
        private HandshakeFailureCallback() {
        }

        @Override
        public void run(IoSession session) {
            if (MllpEndpoint.this.config.isAudit()) {
                String hostAddress = session.getRemoteAddress().toString();
                MllpAuditStrategy.auditAuthenticationNodeFailure(hostAddress);
            }
        }
    }
}

