/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.hl7.HL7MLLPCodec;
import org.apache.camel.component.mina2.Mina2Component;
import org.apache.camel.component.mina2.Mina2Endpoint;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2ConfigurationHolder;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.Hl7v2Interceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpointConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MllpComponent<ConfigType extends MllpEndpointConfiguration>
extends Mina2Component
implements Hl7v2ConfigurationHolder {
    private static final transient Logger LOG = LoggerFactory.getLogger(MllpComponent.class);
    public static final String ACK_TYPE_CODE_HEADER = "ipf.hl7v2.AckTypeCode";
    private static final String DEFAULT_HL7_CODEC_FACTORY_BEAN_NAME = "#hl7codec";

    protected MllpComponent() {
    }

    protected MllpComponent(CamelContext camelContext) {
        super(camelContext);
    }

    protected abstract ConfigType createConfig(Map<String, Object> var1) throws Exception;

    protected abstract MllpEndpoint createEndpoint(Mina2Endpoint var1, ConfigType var2);

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (parameters == Collections.EMPTY_MAP) {
            parameters = new HashMap<String, Object>();
        }
        parameters.put("sync", true);
        parameters.put("lazySessionCreation", true);
        parameters.put("transferExchange", false);
        if (!parameters.containsKey("codec")) {
            parameters.put("codec", DEFAULT_HL7_CODEC_FACTORY_BEAN_NAME);
        }
        ConfigType config = this.createConfig(parameters);
        Charset charset = null;
        try {
            charset = ((HL7MLLPCodec)((MllpEndpointConfiguration)config).getCodecFactory()).getCharset();
        }
        catch (ClassCastException classCastException) {
            LOG.error("Unsupported HL7 codec factory type " + ((MllpEndpointConfiguration)config).getCodecFactory().getClass().getName());
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        parameters.put("encoding", charset.name());
        Endpoint endpoint = super.createEndpoint(uri, "tcp://" + remaining, parameters);
        Mina2Endpoint minaEndpoint = (Mina2Endpoint)endpoint;
        return this.createEndpoint(minaEndpoint, config);
    }

    public List<Hl7v2Interceptor> getAdditionalConsumerInterceptors() {
        return Collections.emptyList();
    }

    public List<Hl7v2Interceptor> getAdditionalProducerInterceptors() {
        return Collections.emptyList();
    }
}

