/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import ca.uhn.hl7v2.model.Message;
import org.apache.camel.Exchange;
import org.openehealth.ipf.commons.ihe.core.atna.AuditorManager;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuditDataset;
import org.openhealthtools.ihe.atna.auditor.codes.rfc3881.RFC3881EventCodes;

public abstract class MllpAuditStrategy<T extends MllpAuditDataset> {
    private final boolean serverSide;

    protected MllpAuditStrategy(boolean serverSide) {
        this.serverSide = serverSide;
    }

    public abstract T createAuditDataset();

    public abstract void enrichAuditDatasetFromRequest(T var1, Message var2, Exchange var3);

    public void enrichAuditDatasetFromResponse(T auditDataset, Message msg) {
    }

    public abstract void doAudit(RFC3881EventCodes.RFC3881EventOutcomeCodes var1, T var2);

    public static void auditAuthenticationNodeFailure(String hostAddress) {
        AuditorManager.getPIXManagerAuditor().auditNodeAuthenticationFailure(true, null, "IPF MLLP Component", null, hostAddress, null);
    }

    protected boolean isServerSide() {
        return this.serverSide;
    }
}

