/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hpd;

import org.apache.camel.Exchange;
import org.openehealth.ipf.commons.ihe.hpd.HpdException;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ErrorResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ObjectFactory;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.ws.AbstractWebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HpdService
extends AbstractWebService {
    private static final Logger log = LoggerFactory.getLogger(HpdService.class);

    public BatchResponse doProcess(BatchRequest request) {
        Exchange result = this.process(request);
        Exception exception = Exchanges.extractException((Exchange)result);
        if (exception != null) {
            log.debug(((Object)((Object)this)).getClass().getSimpleName() + " service failed", (Throwable)exception);
            return this.errorMessage(request, exception);
        }
        return (BatchResponse)result.getMessage().getBody(BatchResponse.class);
    }

    private BatchResponse errorMessage(BatchRequest request, Exception exception) {
        ObjectFactory factory = new ObjectFactory();
        ErrorResponse error = factory.createErrorResponse();
        error.setMessage(exception.getMessage());
        error.setRequestID(request.getRequestID());
        ErrorResponse.ErrorType errorType = exception instanceof HpdException ? ((HpdException)exception).getType() : ErrorResponse.ErrorType.OTHER;
        error.setType(errorType);
        BatchResponse response = factory.createBatchResponse();
        response.setRequestID(request.getRequestID());
        response.getBatchResponses().add(factory.createBatchResponseErrorResponse(error));
        return response;
    }
}

