/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hpd;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.openehealth.ipf.commons.ihe.hpd.HpdValidator;
import org.openehealth.ipf.commons.ihe.hpd.stub.chcidd.DownloadResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.chpidd.DownloadRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchResponse;
import org.openehealth.ipf.platform.camel.core.adapter.ValidatorAdapter;

public class HpdCamelValidators {
    private static final Processor ITI_58_REQUEST_VALIDATOR = exchange -> {
        if (ValidatorAdapter.validationEnabled((Exchange)exchange)) {
            BatchRequest request = (BatchRequest)exchange.getIn().getMandatoryBody(BatchRequest.class);
            HpdValidator.validateIti58Request((BatchRequest)request);
        }
    };
    private static final Processor ITI_58_RESPONSE_VALIDATOR = exchange -> {
        if (ValidatorAdapter.validationEnabled((Exchange)exchange)) {
            BatchResponse response = (BatchResponse)exchange.getIn().getMandatoryBody(BatchResponse.class);
            HpdValidator.validateIti58Response((BatchResponse)response);
        }
    };
    private static final Processor ITI_59_REQUEST_VALIDATOR = exchange -> {
        if (ValidatorAdapter.validationEnabled((Exchange)exchange)) {
            BatchRequest request = (BatchRequest)exchange.getIn().getMandatoryBody(BatchRequest.class);
            HpdValidator.validateIti59Request((BatchRequest)request);
        }
    };
    private static final Processor ITI_59_RESPONSE_VALIDATOR = exchange -> {
        if (ValidatorAdapter.validationEnabled((Exchange)exchange)) {
            BatchResponse response = (BatchResponse)exchange.getIn().getMandatoryBody(BatchResponse.class);
            HpdValidator.validateIti59Response((BatchResponse)response);
        }
    };
    private static final Processor CH_PIDD_REQUEST_VALIDATOR = exchange -> {
        if (ValidatorAdapter.validationEnabled((Exchange)exchange)) {
            DownloadRequest request = (DownloadRequest)exchange.getIn().getMandatoryBody(DownloadRequest.class);
            HpdValidator.validateChPiddRequest((DownloadRequest)request);
        }
    };
    private static final Processor CH_PIDD_RESPONSE_VALIDATOR = exchange -> {
        if (ValidatorAdapter.validationEnabled((Exchange)exchange)) {
            org.openehealth.ipf.commons.ihe.hpd.stub.chpidd.DownloadResponse response = (org.openehealth.ipf.commons.ihe.hpd.stub.chpidd.DownloadResponse)exchange.getIn().getMandatoryBody(org.openehealth.ipf.commons.ihe.hpd.stub.chpidd.DownloadResponse.class);
            HpdValidator.validateChPiddResponse((org.openehealth.ipf.commons.ihe.hpd.stub.chpidd.DownloadResponse)response);
        }
    };
    private static final Processor CH_CIQ_REQUEST_VALIDATOR = exchange -> {
        if (ValidatorAdapter.validationEnabled((Exchange)exchange)) {
            BatchRequest request = (BatchRequest)exchange.getIn().getMandatoryBody(BatchRequest.class);
            HpdValidator.validateChCiqRequest((BatchRequest)request);
        }
    };
    private static final Processor CH_CIQ_RESPONSE_VALIDATOR = exchange -> {
        if (ValidatorAdapter.validationEnabled((Exchange)exchange)) {
            BatchResponse response = (BatchResponse)exchange.getIn().getMandatoryBody(BatchResponse.class);
            HpdValidator.validateChCiqResponse((BatchResponse)response);
        }
    };
    private static final Processor CH_CIDD_REQUEST_VALIDATOR = exchange -> {
        if (ValidatorAdapter.validationEnabled((Exchange)exchange)) {
            org.openehealth.ipf.commons.ihe.hpd.stub.chcidd.DownloadRequest request = (org.openehealth.ipf.commons.ihe.hpd.stub.chcidd.DownloadRequest)exchange.getIn().getMandatoryBody(org.openehealth.ipf.commons.ihe.hpd.stub.chcidd.DownloadRequest.class);
            HpdValidator.validateChCiddRequest((org.openehealth.ipf.commons.ihe.hpd.stub.chcidd.DownloadRequest)request);
        }
    };
    private static final Processor CH_CIDD_RESPONSE_VALIDATOR = exchange -> {
        if (ValidatorAdapter.validationEnabled((Exchange)exchange)) {
            DownloadResponse response = (DownloadResponse)exchange.getIn().getMandatoryBody(DownloadResponse.class);
            HpdValidator.validateChCiddResponse((DownloadResponse)response);
        }
    };

    public static Processor iti58RequestValidator() {
        return ITI_58_REQUEST_VALIDATOR;
    }

    public static Processor iti58ResponseValidator() {
        return ITI_58_RESPONSE_VALIDATOR;
    }

    public static Processor iti59RequestValidator() {
        return ITI_59_REQUEST_VALIDATOR;
    }

    public static Processor iti59ResponseValidator() {
        return ITI_59_RESPONSE_VALIDATOR;
    }

    public static Processor chPiddRequestValidator() {
        return CH_PIDD_REQUEST_VALIDATOR;
    }

    public static Processor chPiddResponseValidator() {
        return CH_PIDD_RESPONSE_VALIDATOR;
    }

    public static Processor chCiqRequestValidator() {
        return CH_CIQ_REQUEST_VALIDATOR;
    }

    public static Processor chCiqResponseValidator() {
        return CH_CIQ_RESPONSE_VALIDATOR;
    }

    public static Processor chCiddRequestValidator() {
        return CH_CIDD_REQUEST_VALIDATOR;
    }

    public static Processor chCiddResponseValidator() {
        return CH_CIDD_RESPONSE_VALIDATOR;
    }
}

