/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.osgi.karaf.commands;

import java.util.Iterator;
import java.util.Map;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.openehealth.ipf.commons.map.BidiMappingService;
import org.openehealth.ipf.commons.map.MappingService;

@Command(scope="ipf", name="listmappings", description="Lists all Mappings available on IPF Mapping Service")
public class ListMappingsCommand
extends OsgiCommandSupport {
    protected Object doExecute() throws Exception {
        BidiMappingService mappingService = (BidiMappingService)this.getService(BidiMappingService.class, this.getBundleContext().getServiceReference(MappingService.class.getCanonicalName()));
        if (mappingService != null && mappingService.getMap() != null) {
            System.out.println("\nAvailable Mappings(" + mappingService.getMap().size() + ")");
            System.out.println("======================== ");
            for (Object key : mappingService.getMap().keySet()) {
                System.out.println("\n\tKey: " + key);
                Map map = (Map)mappingService.getMap().get(key);
                System.out.println("\t-------------------------------------------------");
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    System.out.println("\t\t" + entry.getKey() + " -> " + entry.getValue());
                }
            }
        }
        return null;
    }
}

