/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.osgi.extender.config;

import java.util.Map;
import java.util.Objects;
import org.openehealth.ipf.commons.core.config.ContextFacade;
import org.openehealth.ipf.commons.core.config.Registry;
import org.openehealth.ipf.commons.core.config.SpringRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OsgiServiceRegistry
extends SpringRegistry {
    private final BundleContext bundleContext;

    public OsgiServiceRegistry(BundleContext context) {
        this.bundleContext = context;
        ContextFacade.setRegistry((Registry)this);
    }

    public Object bean(String name) {
        ServiceReference sr = this.bundleContext.getServiceReference(name);
        Object bean = this.bundleContext.getService(sr);
        if (bean != null) {
            return bean;
        }
        return super.bean(name);
    }

    public <T> T bean(Class<T> requiredType) {
        ServiceReference sr = this.bundleContext.getServiceReference(requiredType.getCanonicalName());
        Object bean = this.bundleContext.getService(sr);
        if (bean != null) {
            return (T)bean;
        }
        return (T)super.bean(requiredType);
    }

    public <T> Map<String, T> beans(Class<T> requiredType) {
        return super.beans(requiredType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OsgiServiceRegistry)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OsgiServiceRegistry that = (OsgiServiceRegistry)((Object)o);
        return Objects.equals(this.bundleContext, that.bundleContext);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bundleContext);
    }
}

