/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.osgi.extender.config;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openehealth.ipf.commons.core.config.OrderedConfigurer;
import org.openehealth.ipf.commons.core.config.Registry;
import org.openehealth.ipf.osgi.extender.config.OsgiServiceRegistry;
import org.openehealth.ipf.osgi.extender.config.OsgiSpringConfigurer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.osgi.extender.OsgiBeanFactoryPostProcessor;

public class OsgiSpringConfigurationPostProcessor
implements OsgiBeanFactoryPostProcessor {
    private List<OrderedConfigurer> springConfigurers;
    private List<OsgiSpringConfigurer> osgiSpringConfigurers;

    public void postProcessBeanFactory(BundleContext bundleContext, ConfigurableListableBeanFactory beanFactory) throws BeansException, InvalidSyntaxException, BundleException {
        Collection configurations;
        OsgiServiceRegistry registry = new OsgiServiceRegistry(bundleContext);
        registry.setBeanFactory((BeanFactory)beanFactory);
        for (OsgiSpringConfigurer osc : this.osgiSpringConfigurers) {
            configurations = osc.lookup(bundleContext, registry);
            if (configurations == null || configurations.size() <= 0) continue;
            for (Object configuration : configurations) {
                try {
                    osc.configure(configuration);
                }
                catch (Exception e) {
                    throw new BeanInitializationException("Cannot initialize " + configuration, (Throwable)e);
                }
            }
        }
        for (OrderedConfigurer sc : this.springConfigurers) {
            configurations = sc.lookup((Registry)registry);
            if (configurations == null || configurations.size() <= 0) continue;
            for (Object configuration : configurations) {
                try {
                    sc.configure(configuration);
                }
                catch (Exception e) {
                    throw new BeanInitializationException("Cannot initialize " + configuration, (Throwable)e);
                }
            }
        }
    }

    public List<OrderedConfigurer> getSpringConfigurers() {
        return this.springConfigurers;
    }

    public void setSpringConfigurers(List<OrderedConfigurer> springConfigurers) {
        this.springConfigurers = springConfigurers;
        Collections.sort(springConfigurers);
    }

    public List<OsgiSpringConfigurer> getOsgiSpringConfigurers() {
        return this.osgiSpringConfigurers;
    }

    public void setOsgiSpringConfigurers(List<OsgiSpringConfigurer> osgiSpringConfigurers) {
        this.osgiSpringConfigurers = osgiSpringConfigurers;
    }
}

