/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.modules.hl7.message;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.AbstractPrimitive;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.Escaping;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.util.DeepCopy;
import ca.uhn.hl7v2.util.ReflectionUtil;
import ca.uhn.hl7v2.util.Terser;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openehealth.ipf.modules.hl7.HL7v2Exception;
import org.openehealth.ipf.modules.hl7.parser.DefaultEscaping;

public class MessageUtils
implements GroovyObject {
    private static DateTimeFormatter FMT;
    private static final Escaping ESCAPE;
    private static final Parser PARSER;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public MessageUtils() {
        MetaClass metaClass;
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        Object object = MessageUtils.$getCallSiteArray()[0].call(ISODateTimeFormat.class);
        FMT = (DateTimeFormatter)ScriptBytecodeAdapter.castToType((Object)object, DateTimeFormatter.class);
        Object object2 = MessageUtils.$getCallSiteArray()[1].callGetProperty(DefaultEscaping.class);
        ESCAPE = (Escaping)ScriptBytecodeAdapter.castToType((Object)object2, Escaping.class);
        ParserConfiguration config = (ParserConfiguration)ScriptBytecodeAdapter.castToType((Object)MessageUtils.$getCallSiteArray()[2].callConstructor(ParserConfiguration.class), ParserConfiguration.class);
        Escaping escaping = ESCAPE;
        ScriptBytecodeAdapter.setProperty((Object)escaping, null, (Object)config, (String)"escaping");
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)MessageUtils.$getCallSiteArray()[3].callConstructor(DefaultHapiContext.class), HapiContext.class);
        ParserConfiguration parserConfiguration = config;
        ScriptBytecodeAdapter.setProperty((Object)parserConfiguration, null, (Object)context, (String)"parserConfiguration");
        Object object3 = MessageUtils.$getCallSiteArray()[4].call((Object)context);
        PARSER = (Parser)ScriptBytecodeAdapter.castToType((Object)object3, Parser.class);
    }

    public static boolean atLeastVersion(Message msg, String targetVersion) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callStatic(MessageUtils.class, callSiteArray[6].callGetProperty((Object)msg), (Object)targetVersion));
    }

    public static boolean atLeastVersion(String actualVersion, String targetVersion) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].callStatic(MessageUtils.class, callSiteArray[8].call(Version.class, (Object)actualVersion), callSiteArray[9].call(Version.class, (Object)targetVersion)));
    }

    public static boolean atLeastVersion(Version actualVersion, Version targetVersion) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)actualVersion, null) || ScriptBytecodeAdapter.compareEqual((Object)targetVersion, null)) {
                throw (Throwable)callSiteArray[10].callConstructor(IllegalArgumentException.class, (Object)"unknown HL7 version");
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)actualVersion, null) || ScriptBytecodeAdapter.compareEqual((Object)targetVersion, null)) {
            throw (Throwable)callSiteArray[11].callConstructor(IllegalArgumentException.class, (Object)"unknown HL7 version");
        }
        return !(ScriptBytecodeAdapter.compareEqual((Object)targetVersion, (Object)actualVersion) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].call((Object)targetVersion, (Object)actualVersion)));
    }

    public static String hl7Now() {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[13].call(callSiteArray[14].call((Object)FMT, callSiteArray[15].callConstructor(DateTime.class)), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{ScriptBytecodeAdapter.createRange((Object)0, (Object)7, (boolean)true), ScriptBytecodeAdapter.createRange((Object)9, (Object)14, (boolean)true)})));
    }

    public static String encodeHL7String(String s, Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        Object object = callSiteArray[16].callGetPropertySafe(callSiteArray[17].callGetPropertySafe(callSiteArray[18].callGetPropertySafe((Object)msg)));
        Escaping escaping = (Escaping)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ESCAPE), Escaping.class);
        return ShortTypeHandling.castToString((Object)callSiteArray[19].call((Object)escaping, (Object)s, callSiteArray[20].callStatic(MessageUtils.class, (Object)msg)));
    }

    public static String pipeEncode(Type t) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[21].call((Object)t));
    }

    public static String pipeEncode(Segment s) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[22].call((Object)s));
    }

    public static String eventType(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[23].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[24].callGetProperty((Object)msg), (Object)9, (Object)0, (Object)1, (Object)1)));
    }

    public static String triggerEvent(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[25].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[26].callGetProperty((Object)msg), (Object)9, (Object)0, (Object)2, (Object)1)));
    }

    public static String messageStructure(String messageType, String triggerEvent, String version, ModelClassFactory factory) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        GStringImpl structName = new GStringImpl(new Object[]{messageType, triggerEvent}, new String[]{"", "_", ""});
        Object object = callSiteArray[27].call((Object)factory, (Object)structName, callSiteArray[28].call(Version.class, (Object)version));
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : structName));
    }

    public static String messageStructure(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[29].callStatic(MessageUtils.class, callSiteArray[30].callStatic(MessageUtils.class, (Object)msg), callSiteArray[31].callStatic(MessageUtils.class, (Object)msg), callSiteArray[32].callGetProperty((Object)msg), callSiteArray[33].callGetProperty(callSiteArray[34].callGetProperty(callSiteArray[35].callGetProperty((Object)msg)))));
    }

    public static Message ack(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].call((Object)msg), Message.class);
    }

    public static Message defaultNak(HL7Exception e, AcknowledgmentCode ackCode, String version, String sendingApplication, String sendingFacility, String msh9) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        Object object = callSiteArray[38].callGetProperty((Object)e);
        Object cause = callSiteArray[37].callStatic(MessageUtils.class, DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[39].callGetProperty(callSiteArray[40].callGetProperty((Object)e)), null);
        Object now = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2;
            now = object2 = callSiteArray[41].callStatic(MessageUtils.class);
        } else {
            String string = MessageUtils.hl7Now();
            now = string;
        }
        Object cannedNak = callSiteArray[42].call((Object)new GStringImpl(new Object[]{sendingApplication, sendingFacility, now, msh9, version}, new String[]{"MSH|^~\\&|", "|", "|unknown|unknown|", "||", "|unknown|T|", "|\r"}), (Object)new GStringImpl(new Object[]{cause}, new String[]{"MSA|AE|MsgIdUnknown|", "|\r"}));
        Object nak = callSiteArray[43].call((Object)PARSER, cannedNak);
        callSiteArray[44].call((Object)e, nak, (Object)ackCode, (Object)0);
        return (Message)ScriptBytecodeAdapter.castToType((Object)nak, Message.class);
    }

    public static Message defaultNak(HL7Exception e, AcknowledgmentCode ackCode, String version) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[45].callStatic(MessageUtils.class, ArrayUtil.createArray((Object)((Object)e), (Object)ackCode, (Object)version, (Object)"unknown", (Object)"unknown", (Object)"ACK")), Message.class);
    }

    public static Message newMessage(HapiContext context, String event, String version) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)version)) {
            Object list = callSiteArray[46].call((Object)event, (Object)"_");
            Object eventType = callSiteArray[47].call(list, (Object)0);
            Object triggerEvent = callSiteArray[48].call(list, (Object)1);
            return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[49].callStatic(MessageUtils.class, (Object)context, eventType, triggerEvent, (Object)version), Message.class);
        }
        throw (Throwable)callSiteArray[50].callConstructor(HL7Exception.class, (Object)"Must have valid version to create message");
    }

    public static Message response(Message msg, String eventType, String triggerEvent) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)triggerEvent)) {
            Object object = callSiteArray[51].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[52].callGetProperty((Object)msg), (Object)9, (Object)0, (Object)2, (Object)1));
            triggerEvent = ShortTypeHandling.castToString((Object)object);
        }
        String v = ShortTypeHandling.castToString((Object)callSiteArray[53].callGetProperty((Object)msg));
        Message out = (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].callStatic(MessageUtils.class, callSiteArray[55].callGetProperty(callSiteArray[56].callGetProperty((Object)msg)), (Object)eventType, (Object)triggerEvent, (Object)v), Message.class);
        Segment mshIn = (Segment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].callGetProperty((Object)msg), Segment.class);
        Segment mshOut = (Segment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].callGetProperty((Object)out), Segment.class);
        String fieldSep = ShortTypeHandling.castToString((Object)callSiteArray[59].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)1, (Object)0, (Object)1, (Object)1)));
        String encChars = ShortTypeHandling.castToString((Object)callSiteArray[60].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)2, (Object)0, (Object)1, (Object)1)));
        String procID = ShortTypeHandling.castToString((Object)callSiteArray[61].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)11, (Object)0, (Object)1, (Object)1)));
        callSiteArray[62].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)1, (Object)0, (Object)1, (Object)1, (Object)fieldSep));
        callSiteArray[63].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)2, (Object)0, (Object)1, (Object)1, (Object)encChars));
        callSiteArray[64].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)11, (Object)0, (Object)1, (Object)1, (Object)procID));
        callSiteArray[65].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)3, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[66].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)5, (Object)0, (Object)1, (Object)1))));
        callSiteArray[67].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)4, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[68].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)6, (Object)0, (Object)1, (Object)1))));
        callSiteArray[69].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)5, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[70].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)3, (Object)0, (Object)1, (Object)1))));
        callSiteArray[71].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)6, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[72].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)4, (Object)0, (Object)1, (Object)1))));
        if (ScriptBytecodeAdapter.isCase((Object)"MSA", (Object)callSiteArray[73].callGetProperty((Object)out))) {
            callSiteArray[74].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[75].callGetProperty((Object)out), (Object)2, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[76].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[77].callGetProperty((Object)msg), (Object)10, (Object)0, (Object)1, (Object)1))));
        }
        return out;
    }

    public static Message empty(Message message) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].callStatic(MessageUtils.class, (Object)message, callSiteArray[79].callGetProperty(callSiteArray[80].callGetProperty(callSiteArray[81].callGetProperty((Object)message)))), Message.class);
    }

    public static Message copy(Message source) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].call(callSiteArray[83].callGetProperty((Object)source), callSiteArray[84].call((Object)source)), Message.class);
    }

    private static Group newInstance(Group group, ModelClassFactory factory) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        public final class _newInstance_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _newInstance_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _newInstance_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _newInstance_closure1.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callSafe(callSiteArray[1].callGetProperty(it)), (Object)1) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].call(callSiteArray[3].callGetProperty(it), (Object)0), ModelClassFactory.class);
                }
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].callSafe(callSiteArray[5].callGetProperty(it)), (Object)1) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].call(callSiteArray[7].callGetProperty(it), (Object)0), ModelClassFactory.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _newInstance_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _newInstance_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "size";
                stringArray[1] = "parameterTypes";
                stringArray[2] = "getAt";
                stringArray[3] = "parameterTypes";
                stringArray[4] = "size";
                stringArray[5] = "parameterTypes";
                stringArray[6] = "getAt";
                stringArray[7] = "parameterTypes";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _newInstance_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_newInstance_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _newInstance_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Constructor constructor = (Constructor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[85].callSafe(callSiteArray[86].callGetPropertySafe(callSiteArray[87].callGetPropertySafe((Object)group)), (Object)new _newInstance_closure1(MessageUtils.class, MessageUtils.class)), Constructor.class);
        return (Group)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)constructor) && DefaultTypeTransformation.booleanUnbox((Object)factory) ? callSiteArray[88].call((Object)constructor, (Object)factory) : callSiteArray[89].callStatic(MessageUtils.class, (Object)group)), Group.class);
    }

    private static Group newInstance(Group group) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Group)ScriptBytecodeAdapter.castToType((Object)callSiteArray[90].call(callSiteArray[91].callGetProperty((Object)group)), Group.class);
    }

    public static Message makeMessage(HapiContext context, String eventType, String triggerEvent, String version) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        ModelClassFactory factory = (ModelClassFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[92].callGetProperty((Object)context), ModelClassFactory.class);
        String structName = ScriptBytecodeAdapter.compareEqual((Object)eventType, (Object)"ACK") ? "ACK" : callSiteArray[93].callStatic(MessageUtils.class, (Object)eventType, (Object)triggerEvent, (Object)version, (Object)factory);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[94].call((Object)factory, (Object)structName, (Object)version, (Object)true));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            HL7Exception e = (HL7Exception)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[95].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{structName}, new String[]{"Can't instantiate message ", ""}), callSiteArray[96].callGetProperty(ErrorCode.class)), HL7Exception.class));
            throw (Throwable)callSiteArray[97].callConstructor(HL7v2Exception.class, (Object)e);
        }
        AbstractMessage msg = (AbstractMessage)ScriptBytecodeAdapter.castToType((Object)callSiteArray[98].call(ReflectionUtil.class, (Object)c, (Object)factory), AbstractMessage.class);
        callSiteArray[99].call((Object)msg, callSiteArray[100].call((Object)context));
        callSiteArray[101].call((Object)msg, (Object)eventType, (Object)triggerEvent, (Object)"P");
        callSiteArray[102].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[103].callGetProperty((Object)msg), (Object)11, (Object)0, (Object)2, (Object)1, (Object)"T"));
        return msg;
    }

    public static Segment newSegment(String name, Message message) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[104].call(callSiteArray[105].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[106].call(callSiteArray[107].callGetProperty((Object)context), (Object)name, callSiteArray[108].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[109].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Segment ", ""}));
        }
        return (Segment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[110].call(ReflectionUtil.class, (Object)c, (Object)message, callSiteArray[111].callGetProperty((Object)context)), Segment.class);
    }

    public static Group newGroup(String name, Message message) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[112].call(callSiteArray[113].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[114].call(callSiteArray[115].callGetProperty((Object)context), (Object)name, callSiteArray[116].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[117].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Group ", ""}));
        }
        return (Group)ScriptBytecodeAdapter.castToType((Object)callSiteArray[118].call(ReflectionUtil.class, (Object)c, (Object)message, callSiteArray[119].callGetProperty((Object)context)), Group.class);
    }

    public static Primitive newPrimitive(String name, Message message, String value) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[120].call(callSiteArray[121].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[122].call(callSiteArray[123].callGetProperty((Object)context), (Object)name, callSiteArray[124].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[125].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Type ", ""}));
        }
        AbstractPrimitive primitive = (AbstractPrimitive)ScriptBytecodeAdapter.castToType((Object)callSiteArray[126].call((Object)c, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Object[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{message}), Object[].class)), Object[].class)), AbstractPrimitive.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)value)) {
            callSiteArray[127].call((Object)primitive, (Object)value);
        }
        return primitive;
    }

    public static Composite newComposite(String name, Message message, Map map) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[128].call(callSiteArray[129].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[130].call(callSiteArray[131].callGetProperty((Object)context), (Object)name, callSiteArray[132].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[133].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Type ", ""}));
        }
        Reference composite = new Reference((Object)((Composite)ScriptBytecodeAdapter.castToType((Object)callSiteArray[134].call((Object)c, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Object[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{message}), Object[].class)), Object[].class)), Composite.class)));
        public final class _newComposite_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference composite;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _newComposite_closure2(Object _outerInstance, Object _thisObject, Reference composite) {
                Reference reference;
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.composite = reference = composite;
            }

            public Object doCall(Object k, Object v) {
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                Type type = (Type)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getProperty(_newComposite_closure2.class, (Object)this.composite.get(), (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{k}, new String[]{"", ""}))), Type.class);
                if (type instanceof Primitive && v instanceof String) {
                    return callSiteArray[0].call((Object)type, v);
                }
                return callSiteArray[1].call(DeepCopy.class, v, (Object)type);
            }

            public Object call(Object k, Object v) {
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, k, v);
            }

            public Composite getComposite() {
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                return (Composite)ScriptBytecodeAdapter.castToType((Object)this.composite.get(), Composite.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _newComposite_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "setValue";
                stringArray[1] = "copy";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _newComposite_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_newComposite_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _newComposite_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[135].callSafe((Object)map, (Object)new _newComposite_closure2(MessageUtils.class, MessageUtils.class, composite));
        return (Composite)composite.get();
    }

    public static String dump(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[136].call((Object)msg));
    }

    public static Message load(HapiContext context, String resource) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[137].callStatic(MessageUtils.class, (Object)context, callSiteArray[138].callGetPropertySafe(callSiteArray[139].call(callSiteArray[140].callGetProperty(callSiteArray[141].callStatic(MessageUtils.class)), (Object)resource))), Message.class);
    }

    public static Message load(HapiContext context, String resource, String charset) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[142].callStatic(MessageUtils.class, (Object)context, callSiteArray[143].callSafe(callSiteArray[144].call(callSiteArray[145].callGetProperty(callSiteArray[146].callStatic(MessageUtils.class)), (Object)resource), (Object)charset)), Message.class);
    }

    public static Message make(HapiContext context, InputStream stream) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[147].callStatic(MessageUtils.class, (Object)context, callSiteArray[148].callGetPropertySafe((Object)stream)), Message.class);
    }

    public static Message make(HapiContext context, InputStream stream, String charset) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[149].callStatic(MessageUtils.class, (Object)context, callSiteArray[150].callSafe((Object)stream, (Object)charset)), Message.class);
    }

    public static Message make(HapiContext context, String message) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)message)) {
            return (Message)ScriptBytecodeAdapter.castToType(null, Message.class);
        }
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[151].call(callSiteArray[152].callGetProperty((Object)context), (Object)message), Message.class);
    }

    private static EncodingCharacters encodingCharacters(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)msg, null)) {
            return (EncodingCharacters)ScriptBytecodeAdapter.castToType((Object)callSiteArray[153].call(EncodingCharacters.class, (Object)msg), EncodingCharacters.class);
        }
        return (EncodingCharacters)ScriptBytecodeAdapter.castToType((Object)callSiteArray[154].callConstructor(EncodingCharacters.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)Character.valueOf(DefaultTypeTransformation.charUnbox((Object)ScriptBytecodeAdapter.asType((Object)"|", Character.TYPE))), Character.TYPE), (Object)"^~\\&"), EncodingCharacters.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MessageUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "basicDateTimeNoMillis";
        stringArray[1] = "INSTANCE";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "getGenericParser";
        stringArray[5] = "atLeastVersion";
        stringArray[6] = "version";
        stringArray[7] = "atLeastVersion";
        stringArray[8] = "versionOf";
        stringArray[9] = "versionOf";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "isGreaterThan";
        stringArray[13] = "getAt";
        stringArray[14] = "print";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "escaping";
        stringArray[17] = "parserConfiguration";
        stringArray[18] = "parser";
        stringArray[19] = "escape";
        stringArray[20] = "encodingCharacters";
        stringArray[21] = "encode";
        stringArray[22] = "encode";
        stringArray[23] = "get";
        stringArray[24] = "MSH";
        stringArray[25] = "get";
        stringArray[26] = "MSH";
        stringArray[27] = "getMessageStructureForEvent";
        stringArray[28] = "versionOf";
        stringArray[29] = "messageStructure";
        stringArray[30] = "eventType";
        stringArray[31] = "triggerEvent";
        stringArray[32] = "version";
        stringArray[33] = "modelClassFactory";
        stringArray[34] = "hapiContext";
        stringArray[35] = "parser";
        stringArray[36] = "generateACK";
        stringArray[37] = "encodeHL7String";
        stringArray[38] = "message";
        stringArray[39] = "simpleName";
        stringArray[40] = "class";
        stringArray[41] = "hl7Now";
        stringArray[42] = "plus";
        stringArray[43] = "parse";
        stringArray[44] = "populateResponse";
        stringArray[45] = "defaultNak";
        stringArray[46] = "tokenize";
        stringArray[47] = "getAt";
        stringArray[48] = "getAt";
        stringArray[49] = "makeMessage";
        stringArray[50] = "<$constructor$>";
        stringArray[51] = "get";
        stringArray[52] = "MSH";
        stringArray[53] = "version";
        stringArray[54] = "makeMessage";
        stringArray[55] = "hapiContext";
        stringArray[56] = "parser";
        stringArray[57] = "MSH";
        stringArray[58] = "MSH";
        stringArray[59] = "get";
        stringArray[60] = "get";
        stringArray[61] = "get";
        stringArray[62] = "set";
        stringArray[63] = "set";
        stringArray[64] = "set";
        stringArray[65] = "set";
        stringArray[66] = "get";
        stringArray[67] = "set";
        stringArray[68] = "get";
        stringArray[69] = "set";
        stringArray[70] = "get";
        stringArray[71] = "set";
        stringArray[72] = "get";
        stringArray[73] = "names";
        stringArray[74] = "set";
        stringArray[75] = "MSA";
        stringArray[76] = "get";
        stringArray[77] = "MSH";
        stringArray[78] = "newInstance";
        stringArray[79] = "modelClassFactory";
        stringArray[80] = "hapiContext";
        stringArray[81] = "parser";
        stringArray[82] = "parse";
        stringArray[83] = "parser";
        stringArray[84] = "encode";
        stringArray[85] = "find";
        stringArray[86] = "constructors";
        stringArray[87] = "class";
        stringArray[88] = "newInstance";
        stringArray[89] = "newInstance";
        stringArray[90] = "newInstance";
        stringArray[91] = "class";
        stringArray[92] = "modelClassFactory";
        stringArray[93] = "messageStructure";
        stringArray[94] = "getMessageClass";
        stringArray[95] = "<$constructor$>";
        stringArray[96] = "UNSUPPORTED_MESSAGE_TYPE";
        stringArray[97] = "<$constructor$>";
        stringArray[98] = "instantiateMessage";
        stringArray[99] = "setParser";
        stringArray[100] = "getGenericParser";
        stringArray[101] = "initQuickstart";
        stringArray[102] = "set";
        stringArray[103] = "MSH";
        stringArray[104] = "getHapiContext";
        stringArray[105] = "getParser";
        stringArray[106] = "getSegmentClass";
        stringArray[107] = "modelClassFactory";
        stringArray[108] = "version";
        stringArray[109] = "<$constructor$>";
        stringArray[110] = "instantiateStructure";
        stringArray[111] = "modelClassFactory";
        stringArray[112] = "getHapiContext";
        stringArray[113] = "getParser";
        stringArray[114] = "getGroupClass";
        stringArray[115] = "modelClassFactory";
        stringArray[116] = "version";
        stringArray[117] = "<$constructor$>";
        stringArray[118] = "instantiateStructure";
        stringArray[119] = "modelClassFactory";
        stringArray[120] = "getHapiContext";
        stringArray[121] = "getParser";
        stringArray[122] = "getTypeClass";
        stringArray[123] = "modelClassFactory";
        stringArray[124] = "version";
        stringArray[125] = "<$constructor$>";
        stringArray[126] = "newInstance";
        stringArray[127] = "setValue";
        stringArray[128] = "getHapiContext";
        stringArray[129] = "getParser";
        stringArray[130] = "getTypeClass";
        stringArray[131] = "modelClassFactory";
        stringArray[132] = "version";
        stringArray[133] = "<$constructor$>";
        stringArray[134] = "newInstance";
        stringArray[135] = "each";
        stringArray[136] = "printStructure";
        stringArray[137] = "make";
        stringArray[138] = "text";
        stringArray[139] = "getResource";
        stringArray[140] = "classLoader";
        stringArray[141] = "getClass";
        stringArray[142] = "make";
        stringArray[143] = "getText";
        stringArray[144] = "getResource";
        stringArray[145] = "classLoader";
        stringArray[146] = "getClass";
        stringArray[147] = "make";
        stringArray[148] = "text";
        stringArray[149] = "make";
        stringArray[150] = "getText";
        stringArray[151] = "parse";
        stringArray[152] = "genericParser";
        stringArray[153] = "getInstance";
        stringArray[154] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[155];
        MessageUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(MessageUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = MessageUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

