/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.modules.hl7.config;

import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.Collection;
import org.openehealth.ipf.commons.core.config.OrderedConfigurer;
import org.openehealth.ipf.commons.core.config.Registry;
import org.openehealth.ipf.modules.hl7.config.CustomModelClasses;
import org.openehealth.ipf.modules.hl7.parser.CustomModelClassFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomModelClassFactoryConfigurer<R extends Registry>
extends OrderedConfigurer<CustomModelClasses, R> {
    private CustomModelClassFactory customModelClassFactory;
    private static final Logger LOG = LoggerFactory.getLogger(CustomModelClassFactoryConfigurer.class);
    boolean configureRecursively = true;

    public Collection<CustomModelClasses> lookup(R registry) {
        return registry.beans(CustomModelClasses.class).values();
    }

    public void configure(CustomModelClasses configuration) throws Exception {
        ModelClassFactory delegateFactory = this.configureAndDelegate(this.customModelClassFactory, configuration);
        while (this.isConfigureRecursively() && delegateFactory instanceof CustomModelClassFactory) {
            CustomModelClassFactory currentFactory = (CustomModelClassFactory)delegateFactory;
            delegateFactory = this.configureAndDelegate(currentFactory, configuration);
        }
        LOG.debug("Custom model classes configured: {}", (Object)configuration);
    }

    private ModelClassFactory configureAndDelegate(CustomModelClassFactory factory, CustomModelClasses configuration) {
        factory.addModels(configuration.getModelClasses());
        return factory.getDelegate();
    }

    public CustomModelClassFactory getCustomModelClassFactory() {
        return this.customModelClassFactory;
    }

    public void setCustomModelClassFactory(CustomModelClassFactory customModelClassFactory) {
        this.customModelClassFactory = customModelClassFactory;
    }

    public boolean isConfigureRecursively() {
        return this.configureRecursively;
    }

    public void setConfigureRecursively(boolean configureRecursively) {
        this.configureRecursively = configureRecursively;
    }
}

