/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.modules.hl7.message;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.AbstractPrimitive;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.DefaultEscaping;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.Escaping;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.util.DeepCopy;
import ca.uhn.hl7v2.util.ReflectionUtil;
import ca.uhn.hl7v2.util.Terser;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openehealth.ipf.modules.hl7.HL7v2Exception;

public class MessageUtils
implements GroovyObject {
    private static DateTimeFormatter FMT;
    private static final Escaping ESCAPE;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public MessageUtils() {
        MetaClass metaClass;
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static boolean atLeastVersion(Message msg, String targetVersion) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callStatic(MessageUtils.class, callSiteArray[1].callGetProperty((Object)msg), (Object)targetVersion));
    }

    public static boolean atLeastVersion(String actualVersion, String targetVersion) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callStatic(MessageUtils.class, callSiteArray[3].call(Version.class, (Object)actualVersion), callSiteArray[4].call(Version.class, (Object)targetVersion)));
    }

    public static boolean atLeastVersion(Version actualVersion, Version targetVersion) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)actualVersion, null) || ScriptBytecodeAdapter.compareEqual((Object)targetVersion, null)) {
                throw (Throwable)callSiteArray[5].callConstructor(IllegalArgumentException.class, (Object)"unknown HL7 version");
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)actualVersion, null) || ScriptBytecodeAdapter.compareEqual((Object)targetVersion, null)) {
            throw (Throwable)callSiteArray[6].callConstructor(IllegalArgumentException.class, (Object)"unknown HL7 version");
        }
        return !(ScriptBytecodeAdapter.compareEqual((Object)targetVersion, (Object)actualVersion) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].call((Object)targetVersion, (Object)actualVersion)));
    }

    public static String hl7Now() {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[8].call(callSiteArray[9].call((Object)FMT, callSiteArray[10].callConstructor(DateTime.class)), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{ScriptBytecodeAdapter.createRange((Object)0, (Object)7, (boolean)true), ScriptBytecodeAdapter.createRange((Object)9, (Object)14, (boolean)true)})));
    }

    public static String encodeHL7String(String s, Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        Object object = callSiteArray[11].callGetPropertySafe(callSiteArray[12].callGetPropertySafe(callSiteArray[13].callGetPropertySafe((Object)msg)));
        Escaping escaping = (Escaping)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ESCAPE), Escaping.class);
        return ShortTypeHandling.castToString((Object)callSiteArray[14].call((Object)escaping, (Object)s, callSiteArray[15].callStatic(MessageUtils.class, (Object)msg)));
    }

    public static String pipeEncode(Type t) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[16].call((Object)t));
    }

    public static String pipeEncode(Segment s) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[17].call((Object)s));
    }

    public static String eventType(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[18].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[19].callGetProperty((Object)msg), (Object)9, (Object)0, (Object)1, (Object)1)));
    }

    public static String triggerEvent(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[20].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[21].callGetProperty((Object)msg), (Object)9, (Object)0, (Object)2, (Object)1)));
    }

    public static String messageStructure(String messageType, String triggerEvent, String version, ModelClassFactory factory) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        GStringImpl structName = new GStringImpl(new Object[]{messageType, triggerEvent}, new String[]{"", "_", ""});
        Object object = callSiteArray[22].call((Object)factory, (Object)structName, callSiteArray[23].call(Version.class, (Object)version));
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : structName));
    }

    public static String messageStructure(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[24].callStatic(MessageUtils.class, callSiteArray[25].callStatic(MessageUtils.class, (Object)msg), callSiteArray[26].callStatic(MessageUtils.class, (Object)msg), callSiteArray[27].callGetProperty((Object)msg), callSiteArray[28].callGetProperty(callSiteArray[29].callGetProperty(callSiteArray[30].callGetProperty((Object)msg)))));
    }

    public static Message ack(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].call((Object)msg), Message.class);
    }

    public static Message defaultNak(HL7Exception e, AcknowledgmentCode ackCode, String version, String sendingApplication, String sendingFacility, String msh9) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        Object object = callSiteArray[33].callGetProperty((Object)e);
        Object cause = callSiteArray[32].callStatic(MessageUtils.class, DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[34].callGetProperty(callSiteArray[35].callGetProperty((Object)e)), null);
        Object now = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2;
            now = object2 = callSiteArray[36].callStatic(MessageUtils.class);
        } else {
            String string = MessageUtils.hl7Now();
            now = string;
        }
        Object cannedNak = callSiteArray[37].call((Object)new GStringImpl(new Object[]{sendingApplication, sendingFacility, now, msh9, version}, new String[]{"MSH|^~\\&|", "|", "|unknown|unknown|", "||", "|unknown|T|", "|\r"}), (Object)new GStringImpl(new Object[]{cause}, new String[]{"MSA|AE|MsgIdUnknown|", "|\r"}));
        Object nak = callSiteArray[38].call(callSiteArray[39].callConstructor(GenericParser.class), cannedNak);
        callSiteArray[40].call((Object)e, nak, (Object)ackCode, (Object)0);
        return (Message)ScriptBytecodeAdapter.castToType((Object)nak, Message.class);
    }

    public static Message defaultNak(HL7Exception e, AcknowledgmentCode ackCode, String version) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].callStatic(MessageUtils.class, ArrayUtil.createArray((Object)((Object)e), (Object)ackCode, (Object)version, (Object)"unknown", (Object)"unknown", (Object)"ACK")), Message.class);
    }

    public static Message newMessage(HapiContext context, String event, String version) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)version)) {
            Object list = callSiteArray[42].call((Object)event, (Object)"_");
            Object eventType = callSiteArray[43].call(list, (Object)0);
            Object triggerEvent = callSiteArray[44].call(list, (Object)1);
            return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[45].callStatic(MessageUtils.class, (Object)context, eventType, triggerEvent, (Object)version), Message.class);
        }
        throw (Throwable)callSiteArray[46].callConstructor(HL7Exception.class, (Object)"Must have valid version to create message");
    }

    public static Message response(Message msg, String eventType, String triggerEvent) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)triggerEvent)) {
            Object object = callSiteArray[47].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[48].callGetProperty((Object)msg), (Object)9, (Object)0, (Object)2, (Object)1));
            triggerEvent = ShortTypeHandling.castToString((Object)object);
        }
        String v = ShortTypeHandling.castToString((Object)callSiteArray[49].callGetProperty((Object)msg));
        Message out = (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].callStatic(MessageUtils.class, callSiteArray[51].callGetProperty(callSiteArray[52].callGetProperty((Object)msg)), (Object)eventType, (Object)triggerEvent, (Object)v), Message.class);
        Segment mshIn = (Segment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].callGetProperty((Object)msg), Segment.class);
        Segment mshOut = (Segment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].callGetProperty((Object)out), Segment.class);
        String fieldSep = ShortTypeHandling.castToString((Object)callSiteArray[55].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)1, (Object)0, (Object)1, (Object)1)));
        String encChars = ShortTypeHandling.castToString((Object)callSiteArray[56].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)2, (Object)0, (Object)1, (Object)1)));
        String procID = ShortTypeHandling.castToString((Object)callSiteArray[57].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)11, (Object)0, (Object)1, (Object)1)));
        callSiteArray[58].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)1, (Object)0, (Object)1, (Object)1, (Object)fieldSep));
        callSiteArray[59].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)2, (Object)0, (Object)1, (Object)1, (Object)encChars));
        callSiteArray[60].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)11, (Object)0, (Object)1, (Object)1, (Object)procID));
        callSiteArray[61].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)3, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[62].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)5, (Object)0, (Object)1, (Object)1))));
        callSiteArray[63].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)4, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[64].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)6, (Object)0, (Object)1, (Object)1))));
        callSiteArray[65].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)5, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[66].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)3, (Object)0, (Object)1, (Object)1))));
        callSiteArray[67].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)6, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[68].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)4, (Object)0, (Object)1, (Object)1))));
        if (ScriptBytecodeAdapter.isCase((Object)"MSA", (Object)callSiteArray[69].callGetProperty((Object)out))) {
            callSiteArray[70].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[71].callGetProperty((Object)out), (Object)2, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[72].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[73].callGetProperty((Object)msg), (Object)10, (Object)0, (Object)1, (Object)1))));
        }
        return out;
    }

    public static Message empty(Message message) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].callStatic(MessageUtils.class, (Object)message, callSiteArray[75].callGetProperty(callSiteArray[76].callGetProperty(callSiteArray[77].callGetProperty((Object)message)))), Message.class);
    }

    public static Message copy(Message source) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].call(callSiteArray[79].callGetProperty((Object)source), callSiteArray[80].call((Object)source)), Message.class);
    }

    private static Group newInstance(Group group, ModelClassFactory factory) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        Constructor constructor = (Constructor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].callSafe(callSiteArray[82].callGetPropertySafe(callSiteArray[83].callGetPropertySafe((Object)group)), (Object)new GeneratedClosure(MessageUtils.class, MessageUtils.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _newInstance_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _newInstance_closure1.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callSafe(callSiteArray[1].callGetProperty(it)), (Object)1) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].call(callSiteArray[3].callGetProperty(it), (Object)0), ModelClassFactory.class);
                }
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].callSafe(callSiteArray[5].callGetProperty(it)), (Object)1) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].call(callSiteArray[7].callGetProperty(it), (Object)0), ModelClassFactory.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _newInstance_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _newInstance_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "size";
                stringArray[1] = "parameterTypes";
                stringArray[2] = "getAt";
                stringArray[3] = "parameterTypes";
                stringArray[4] = "size";
                stringArray[5] = "parameterTypes";
                stringArray[6] = "getAt";
                stringArray[7] = "parameterTypes";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _newInstance_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_newInstance_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _newInstance_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), Constructor.class);
        return (Group)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)constructor) && DefaultTypeTransformation.booleanUnbox((Object)factory) ? callSiteArray[84].call((Object)constructor, (Object)factory) : callSiteArray[85].callStatic(MessageUtils.class, (Object)group)), Group.class);
    }

    private static Group newInstance(Group group) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Group)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].call(callSiteArray[87].callGetProperty((Object)group)), Group.class);
    }

    public static Message makeMessage(HapiContext context, String eventType, String triggerEvent, String version) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        ModelClassFactory factory = (ModelClassFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[88].callGetProperty((Object)context), ModelClassFactory.class);
        String structName = ScriptBytecodeAdapter.compareEqual((Object)eventType, (Object)"ACK") ? "ACK" : callSiteArray[89].callStatic(MessageUtils.class, (Object)eventType, (Object)triggerEvent, (Object)version, (Object)factory);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[90].call((Object)factory, (Object)structName, (Object)version, (Object)true));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            HL7Exception e = (HL7Exception)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{structName}, new String[]{"Can't instantiate message ", ""}), callSiteArray[92].callGetProperty(ErrorCode.class)), HL7Exception.class));
            throw (Throwable)callSiteArray[93].callConstructor(HL7v2Exception.class, (Object)e);
        }
        AbstractMessage msg = (AbstractMessage)ScriptBytecodeAdapter.castToType((Object)callSiteArray[94].call(ReflectionUtil.class, (Object)c, (Object)factory), AbstractMessage.class);
        callSiteArray[95].call((Object)msg, callSiteArray[96].call((Object)context));
        callSiteArray[97].call((Object)msg, (Object)eventType, (Object)triggerEvent, (Object)"P");
        callSiteArray[98].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[99].callGetProperty((Object)msg), (Object)11, (Object)0, (Object)2, (Object)1, (Object)"T"));
        return msg;
    }

    public static Segment newSegment(String name, Message message) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[100].call(callSiteArray[101].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[102].call(callSiteArray[103].callGetProperty((Object)context), (Object)name, callSiteArray[104].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[105].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Segment ", ""}));
        }
        return (Segment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[106].call(ReflectionUtil.class, (Object)c, (Object)message, callSiteArray[107].callGetProperty((Object)context)), Segment.class);
    }

    public static Group newGroup(String name, Message message) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[108].call(callSiteArray[109].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[110].call(callSiteArray[111].callGetProperty((Object)context), (Object)name, callSiteArray[112].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[113].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Group ", ""}));
        }
        return (Group)ScriptBytecodeAdapter.castToType((Object)callSiteArray[114].call(ReflectionUtil.class, (Object)c, (Object)message, callSiteArray[115].callGetProperty((Object)context)), Group.class);
    }

    public static Primitive newPrimitive(String name, Message message, String value) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[116].call(callSiteArray[117].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[118].call(callSiteArray[119].callGetProperty((Object)context), (Object)name, callSiteArray[120].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[121].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Type ", ""}));
        }
        AbstractPrimitive primitive = (AbstractPrimitive)ScriptBytecodeAdapter.castToType((Object)callSiteArray[122].call((Object)c, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Object[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{message}), Object[].class)), Object[].class)), AbstractPrimitive.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)value)) {
            callSiteArray[123].call((Object)primitive, (Object)value);
        }
        return primitive;
    }

    public static Composite newComposite(String name, Message message, Map map) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[124].call(callSiteArray[125].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[126].call(callSiteArray[127].callGetProperty((Object)context), (Object)name, callSiteArray[128].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[129].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Type ", ""}));
        }
        Reference composite = new Reference((Object)((Composite)ScriptBytecodeAdapter.castToType((Object)callSiteArray[130].call((Object)c, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Object[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{message}), Object[].class)), Object[].class)), Composite.class)));
        callSiteArray[131].callSafe((Object)map, (Object)new GeneratedClosure(MessageUtils.class, MessageUtils.class, composite){
            private /* synthetic */ Reference composite;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.composite = reference = composite;
            }

            public Object doCall(Object k, Object v) {
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                Type type = (Type)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getProperty(_newComposite_closure2.class, (Object)this.composite.get(), (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{k}, new String[]{"", ""}))), Type.class);
                if (type instanceof Primitive && v instanceof String) {
                    return callSiteArray[0].call((Object)type, v);
                }
                return callSiteArray[1].call(DeepCopy.class, v, (Object)type);
            }

            public Object call(Object k, Object v) {
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, k, v);
            }

            public Composite getComposite() {
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                return (Composite)ScriptBytecodeAdapter.castToType((Object)this.composite.get(), Composite.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _newComposite_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "setValue";
                stringArray[1] = "copy";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _newComposite_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_newComposite_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _newComposite_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        return (Composite)composite.get();
    }

    public static String dump(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[132].call((Object)msg));
    }

    private static EncodingCharacters encodingCharacters(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)msg, null)) {
            return (EncodingCharacters)ScriptBytecodeAdapter.castToType((Object)callSiteArray[133].call(EncodingCharacters.class, (Object)msg), EncodingCharacters.class);
        }
        return (EncodingCharacters)ScriptBytecodeAdapter.castToType((Object)callSiteArray[134].callConstructor(EncodingCharacters.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)Character.valueOf(DefaultTypeTransformation.charUnbox((Object)ScriptBytecodeAdapter.asType((Object)"|", Character.TYPE))), Character.TYPE), (Object)"^~\\&"), EncodingCharacters.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MessageUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = MessageUtils.$getCallSiteArray()[135].call(ISODateTimeFormat.class);
        FMT = (DateTimeFormatter)ScriptBytecodeAdapter.castToType((Object)object, DateTimeFormatter.class);
        Object object2 = MessageUtils.$getCallSiteArray()[136].callConstructor(DefaultEscaping.class);
        ESCAPE = (Escaping)ScriptBytecodeAdapter.castToType((Object)object2, Escaping.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "atLeastVersion";
        stringArray[1] = "version";
        stringArray[2] = "atLeastVersion";
        stringArray[3] = "versionOf";
        stringArray[4] = "versionOf";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "isGreaterThan";
        stringArray[8] = "getAt";
        stringArray[9] = "print";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "escaping";
        stringArray[12] = "parserConfiguration";
        stringArray[13] = "parser";
        stringArray[14] = "escape";
        stringArray[15] = "encodingCharacters";
        stringArray[16] = "encode";
        stringArray[17] = "encode";
        stringArray[18] = "get";
        stringArray[19] = "MSH";
        stringArray[20] = "get";
        stringArray[21] = "MSH";
        stringArray[22] = "getMessageStructureForEvent";
        stringArray[23] = "versionOf";
        stringArray[24] = "messageStructure";
        stringArray[25] = "eventType";
        stringArray[26] = "triggerEvent";
        stringArray[27] = "version";
        stringArray[28] = "modelClassFactory";
        stringArray[29] = "hapiContext";
        stringArray[30] = "parser";
        stringArray[31] = "generateACK";
        stringArray[32] = "encodeHL7String";
        stringArray[33] = "message";
        stringArray[34] = "simpleName";
        stringArray[35] = "class";
        stringArray[36] = "hl7Now";
        stringArray[37] = "plus";
        stringArray[38] = "parse";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "populateResponse";
        stringArray[41] = "defaultNak";
        stringArray[42] = "tokenize";
        stringArray[43] = "getAt";
        stringArray[44] = "getAt";
        stringArray[45] = "makeMessage";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "get";
        stringArray[48] = "MSH";
        stringArray[49] = "version";
        stringArray[50] = "makeMessage";
        stringArray[51] = "hapiContext";
        stringArray[52] = "parser";
        stringArray[53] = "MSH";
        stringArray[54] = "MSH";
        stringArray[55] = "get";
        stringArray[56] = "get";
        stringArray[57] = "get";
        stringArray[58] = "set";
        stringArray[59] = "set";
        stringArray[60] = "set";
        stringArray[61] = "set";
        stringArray[62] = "get";
        stringArray[63] = "set";
        stringArray[64] = "get";
        stringArray[65] = "set";
        stringArray[66] = "get";
        stringArray[67] = "set";
        stringArray[68] = "get";
        stringArray[69] = "names";
        stringArray[70] = "set";
        stringArray[71] = "MSA";
        stringArray[72] = "get";
        stringArray[73] = "MSH";
        stringArray[74] = "newInstance";
        stringArray[75] = "modelClassFactory";
        stringArray[76] = "hapiContext";
        stringArray[77] = "parser";
        stringArray[78] = "parse";
        stringArray[79] = "parser";
        stringArray[80] = "encode";
        stringArray[81] = "find";
        stringArray[82] = "constructors";
        stringArray[83] = "class";
        stringArray[84] = "newInstance";
        stringArray[85] = "newInstance";
        stringArray[86] = "newInstance";
        stringArray[87] = "class";
        stringArray[88] = "modelClassFactory";
        stringArray[89] = "messageStructure";
        stringArray[90] = "getMessageClass";
        stringArray[91] = "<$constructor$>";
        stringArray[92] = "UNSUPPORTED_MESSAGE_TYPE";
        stringArray[93] = "<$constructor$>";
        stringArray[94] = "instantiateMessage";
        stringArray[95] = "setParser";
        stringArray[96] = "getGenericParser";
        stringArray[97] = "initQuickstart";
        stringArray[98] = "set";
        stringArray[99] = "MSH";
        stringArray[100] = "getHapiContext";
        stringArray[101] = "getParser";
        stringArray[102] = "getSegmentClass";
        stringArray[103] = "modelClassFactory";
        stringArray[104] = "version";
        stringArray[105] = "<$constructor$>";
        stringArray[106] = "instantiateStructure";
        stringArray[107] = "modelClassFactory";
        stringArray[108] = "getHapiContext";
        stringArray[109] = "getParser";
        stringArray[110] = "getGroupClass";
        stringArray[111] = "modelClassFactory";
        stringArray[112] = "version";
        stringArray[113] = "<$constructor$>";
        stringArray[114] = "instantiateStructure";
        stringArray[115] = "modelClassFactory";
        stringArray[116] = "getHapiContext";
        stringArray[117] = "getParser";
        stringArray[118] = "getTypeClass";
        stringArray[119] = "modelClassFactory";
        stringArray[120] = "version";
        stringArray[121] = "<$constructor$>";
        stringArray[122] = "newInstance";
        stringArray[123] = "setValue";
        stringArray[124] = "getHapiContext";
        stringArray[125] = "getParser";
        stringArray[126] = "getTypeClass";
        stringArray[127] = "modelClassFactory";
        stringArray[128] = "version";
        stringArray[129] = "<$constructor$>";
        stringArray[130] = "newInstance";
        stringArray[131] = "each";
        stringArray[132] = "printStructure";
        stringArray[133] = "getInstance";
        stringArray[134] = "<$constructor$>";
        stringArray[135] = "basicDateTimeNoMillis";
        stringArray[136] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[137];
        MessageUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(MessageUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = MessageUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

