/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.modules.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.util.Terser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.openehealth.ipf.modules.hl7.AbstractHL7v2Exception;
import org.openehealth.ipf.modules.hl7.AckTypeCode;
import org.openehealth.ipf.modules.hl7.message.MessageUtils;

public class CompositeHL7v2Exception
extends AbstractHL7v2Exception
implements Iterable<AbstractHL7v2Exception> {
    private final List<AbstractHL7v2Exception> wrapped;

    public CompositeHL7v2Exception() {
        this("HL7 Processing Error", new ArrayList<AbstractHL7v2Exception>());
    }

    public CompositeHL7v2Exception(List<AbstractHL7v2Exception> wrapped) {
        this("HL7 Processing Error", wrapped);
    }

    public CompositeHL7v2Exception(AbstractHL7v2Exception[] wrapped) {
        this("HL7 Processing Error", Arrays.asList(wrapped));
    }

    public CompositeHL7v2Exception(String message, AbstractHL7v2Exception[] wrapped) {
        this(message, Arrays.asList(wrapped));
    }

    public CompositeHL7v2Exception(String message) {
        this(message, new ArrayList<AbstractHL7v2Exception>());
    }

    public CompositeHL7v2Exception(String message, List<AbstractHL7v2Exception> wrapped) {
        super(message);
        this.wrapped = wrapped;
    }

    public boolean add(AbstractHL7v2Exception exception) {
        return this.wrapped.add(exception);
    }

    @Override
    public Message populateMessage(Message m, AckTypeCode code) {
        try {
            if (MessageUtils.atLeastVersion(m, "2.5")) {
                Segment errorSegment = (Segment)m.get("ERR");
                this.fillErr347(errorSegment);
            } else {
                Segment msaSegment = (Segment)m.get("MSA");
                Terser.set((Segment)msaSegment, (int)3, (int)0, (int)1, (int)1, (String)this.getMessage());
            }
            for (AbstractHL7v2Exception exception : this.wrapped) {
                exception.populateMessage(m, code);
            }
            return m;
        }
        catch (HL7Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<AbstractHL7v2Exception> iterator() {
        return this.wrapped.iterator();
    }
}

