/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.modules.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.util.Terser;
import org.openehealth.ipf.modules.hl7.AckTypeCode;
import org.openehealth.ipf.modules.hl7.HL70357;

public abstract class AbstractHL7v2Exception
extends RuntimeException {
    private int errCode = 207;

    public AbstractHL7v2Exception() {
    }

    public AbstractHL7v2Exception(String message) {
        super(message);
    }

    public AbstractHL7v2Exception(String message, int errCode) {
        super(message);
        this.errCode = errCode;
    }

    public AbstractHL7v2Exception(String message, Throwable cause) {
        super(message, cause);
    }

    public AbstractHL7v2Exception(String message, int errCode, Throwable cause) {
        super(message, cause);
        this.errCode = errCode;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public String getErrorMessage() {
        return HL70357.messageFor(this.getErrCode());
    }

    public abstract Message populateMessage(Message var1, AckTypeCode var2);

    protected void fillErr347(Segment errorSegment) throws HL7Exception {
        Terser.set((Segment)errorSegment, (int)3, (int)0, (int)1, (int)1, (String)String.valueOf(this.getErrCode()));
        Terser.set((Segment)errorSegment, (int)3, (int)0, (int)2, (int)1, (String)this.getErrorMessage());
        Terser.set((Segment)errorSegment, (int)3, (int)0, (int)3, (int)1, (String)"HL70357");
        Terser.set((Segment)errorSegment, (int)3, (int)0, (int)5, (int)1, (String)this.getMessage());
        Terser.set((Segment)errorSegment, (int)4, (int)0, (int)1, (int)1, (String)"E");
        Terser.set((Segment)errorSegment, (int)7, (int)0, (int)1, (int)1, (String)this.getMessage());
    }
}

