/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.modules.hl7.validation.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.builder.Predicate;
import java.util.Collection;
import org.openehealth.ipf.modules.hl7.validation.model.CompositeTypeRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompositeTypeRule<T extends Composite>
extends CompositeTypeRule<T> {
    public static final String EUI_64_PATTERN = "[0-9a-zA-Z]+";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCompositeTypeRule.class);
    private final String appliesFor;
    private final String description;

    public AbstractCompositeTypeRule(Class<T> compositeTypeClass) {
        this(compositeTypeClass, String.valueOf(compositeTypeClass.getSimpleName()) + " composite type rule");
    }

    public AbstractCompositeTypeRule(Class<T> compositeTypeClass, String description) {
        this.appliesFor = compositeTypeClass.getSimpleName();
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean matches(Class<? extends Composite> clazz) {
        return clazz.getSimpleName().equals(this.appliesFor);
    }

    public String getSectionReference() {
        return "";
    }

    public ValidationException[] apply(Composite composite) {
        return this.apply(composite, Location.UNKNOWN);
    }

    @Override
    public ValidationException[] apply(T composite, Location location) {
        if (this.matches(composite.getClass())) {
            return this.validate(composite, location);
        }
        throw new IllegalArgumentException("The rule " + ((Object)((Object)this)).getClass().getSimpleName() + " does not apply for class " + composite.getClass().getName());
    }

    public abstract ValidationException[] validate(T var1, Location var2);

    protected ValidationException[] violations(Object value, Location location) {
        String msg = String.format(this.getDescription(), String.valueOf(value));
        ValidationException ve = new ValidationException(msg);
        ve.setLocation(location);
        return new ValidationException[]{ve};
    }

    public boolean isEmpty(T element, int component) {
        try {
            return this.empty().evaluate((Object)this.val(element, component));
        }
        catch (ValidationException validationException) {
            return false;
        }
    }

    public boolean isNonEmpty(T element, int component) {
        return !this.isEmpty(element, component);
    }

    public boolean isEqual(String expected, T element, int component) {
        try {
            return this.isEqual(expected).evaluate((Object)this.val(element, component));
        }
        catch (ValidationException validationException) {
            return false;
        }
    }

    public ValidationException enforce(Predicate p, T element, int component) {
        String val = this.val(element, component);
        try {
            return p.evaluate((Object)val) ? null : new ValidationException(String.format("%s requires to be %s", val, p.getDescription()));
        }
        catch (ValidationException e) {
            return e;
        }
    }

    protected AbstractCompositeTypeRule<T> validate(ValidationException e, Location l, Collection<ValidationException> violations) {
        if (e != null) {
            e.setLocation(l);
            violations.add(e);
        }
        return this;
    }

    protected ValidationException violation(String msg) {
        return new ValidationException(msg);
    }

    protected String val(T element, int component) {
        try {
            Type type = element.getComponent(component - 1);
            if (type instanceof Primitive) {
                return ((Primitive)type).getValue();
            }
            if (type != null) {
                return type.encode();
            }
        }
        catch (DataTypeException dte) {
            LOG.warn("Unable to extract the value of the HL7 type.", (Throwable)dte);
        }
        catch (HL7Exception e) {
            LOG.error("Unable to get the fieldSeparatorValue.", (Throwable)e);
        }
        return null;
    }

    private String msgPrefix(String expected, String found) {
        String val = "".equals(found) ? " empty value " : found;
        return "Expected " + expected + ", found " + val;
    }

    protected String msg(String prefix, Composite element, int component, String path) {
        String reference = this.getSectionReference();
        String elementType = element.getClass().getSimpleName();
        return "Validation error: " + (reference == null ? "rule for type " + elementType : reference) + " : " + prefix + " of type " + elementType + ", component " + component + ", path " + path;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.appliesFor == null ? 0 : this.appliesFor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractCompositeTypeRule other = (AbstractCompositeTypeRule)((Object)obj);
        return !(this.appliesFor == null ? other.appliesFor != null : !this.appliesFor.equals(other.appliesFor));
    }
}

