/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.modules.hl7.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openehealth.ipf.modules.hl7.HL7v2Exception;

public abstract class AbstractMessage
extends ca.uhn.hl7v2.model.AbstractMessage {
    public AbstractMessage() {
        super((ModelClassFactory)new DefaultModelClassFactory());
        this.init();
    }

    public AbstractMessage(ModelClassFactory factory) {
        super(factory);
        this.init();
    }

    private void init() {
        try {
            for (Map.Entry<Class<? extends Structure>, Cardinality> structure : this.structures(new LinkedHashMap<Class<? extends Structure>, Cardinality>()).entrySet()) {
                switch (structure.getValue()) {
                    case REQUIRED: {
                        this.add(structure.getKey(), true, false);
                        break;
                    }
                    case REQUIRED_REPEATING: {
                        this.add(structure.getKey(), true, true);
                        break;
                    }
                    case OPTIONAL: {
                        this.add(structure.getKey(), false, false);
                        break;
                    }
                    case OPTIONAL_REPEATING: {
                        this.add(structure.getKey(), false, true);
                        break;
                    }
                }
            }
        }
        catch (HL7Exception e) {
            throw new HL7v2Exception(e);
        }
    }

    protected <T extends Structure> T get(Class<T> structureClass) {
        return (T)super.getTyped(structureClass.getSimpleName(), structureClass);
    }

    protected <T extends Structure> T get(String structure, Class<T> structureClass) {
        return (T)super.getTyped(structure, structureClass);
    }

    protected <T extends Structure> T get(Class<T> structureClass, int rep) {
        return (T)super.getTyped(structureClass.getSimpleName(), rep, structureClass);
    }

    protected <T extends Structure> T get(String structure, Class<T> structureClass, int rep) {
        return (T)super.getTyped(structure, rep, structureClass);
    }

    protected <T extends Structure> int getReps(Class<T> structureClass) {
        return super.getReps(structureClass.getSimpleName());
    }

    protected <T extends Structure> int getReps(String structure, Class<T> structureClass) {
        return super.getReps(structure);
    }

    protected abstract Map<Class<? extends Structure>, Cardinality> structures(Map<Class<? extends Structure>, Cardinality> var1);

    protected static enum Cardinality {
        REQUIRED,
        OPTIONAL,
        REQUIRED_REPEATING,
        OPTIONAL_REPEATING;

    }
}

