/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.modules.hl7.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CustomModelClassFactory
extends ca.uhn.hl7v2.parser.CustomModelClassFactory {
    private ModelClassFactory defaultFactory;
    private final ConcurrentMap<String, Class<?>> classMap = new ConcurrentHashMap();

    public CustomModelClassFactory() {
        this(null);
    }

    public CustomModelClassFactory(Map<String, String[]> map) {
        this((ModelClassFactory)new DefaultModelClassFactory(), map);
    }

    public CustomModelClassFactory(String packageName, ModelClassFactory defaultFactory) {
        super(packageName);
        this.defaultFactory = defaultFactory;
    }

    public CustomModelClassFactory(ModelClassFactory defaultFactory, Map<String, String[]> map) {
        super(defaultFactory, map);
        this.defaultFactory = defaultFactory;
    }

    public Class<? extends Message> getMessageClass(String name, String version, boolean isExplicit) throws HL7Exception {
        String key = "message" + name + version;
        Class clazz = (Class)this.classMap.get(key);
        if (clazz == null && (clazz = super.getMessageClass(name, version, isExplicit)) != null) {
            this.classMap.putIfAbsent(key, clazz);
        }
        return clazz;
    }

    public Class<? extends Group> getGroupClass(String name, String version) throws HL7Exception {
        String key = "group" + name + version;
        Class clazz = (Class)this.classMap.get(key);
        if (clazz == null && (clazz = super.getGroupClass(name, version)) != null) {
            this.classMap.putIfAbsent(key, clazz);
        }
        return clazz;
    }

    public Class<? extends Segment> getSegmentClass(String name, String version) throws HL7Exception {
        String key = "segment" + name + version;
        Class clazz = (Class)this.classMap.get(key);
        if (clazz == null && (clazz = super.getSegmentClass(name, version)) != null) {
            this.classMap.putIfAbsent(key, clazz);
        }
        return clazz;
    }

    public Class<? extends Type> getTypeClass(String name, String version) throws HL7Exception {
        String key = "type" + name + version;
        Class clazz = (Class)this.classMap.get(key);
        if (clazz == null && (clazz = super.getTypeClass(name, version)) != null) {
            this.classMap.putIfAbsent(key, clazz);
        }
        return clazz;
    }

    public String getMessageStructureForEvent(String eventName, Version version) throws HL7Exception {
        Map p = this.getEventMapForVersion(version);
        if (p == null) {
            throw new HL7Exception("No map found for version " + version);
        }
        String structure = (String)p.get(eventName);
        if (structure == null) {
            structure = this.defaultFactory.getMessageStructureForEvent(eventName, version);
        }
        if (structure == null) {
            structure = eventName;
        }
        return structure;
    }

    public ModelClassFactory getDelegate() {
        return this.defaultFactory;
    }
}

