/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.spring.map.config;

import java.util.Collection;
import org.openehealth.ipf.commons.core.config.OrderedConfigurer;
import org.openehealth.ipf.commons.core.config.Registry;
import org.openehealth.ipf.commons.spring.map.MappingResourceHolder;
import org.openehealth.ipf.commons.spring.map.SpringBidiMappingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMappingsConfigurer<R extends Registry>
extends OrderedConfigurer<MappingResourceHolder, R> {
    private SpringBidiMappingService mappingService;
    private static final Logger LOG = LoggerFactory.getLogger(CustomMappingsConfigurer.class);

    public Collection<MappingResourceHolder> lookup(Registry registry) {
        return registry.beans(MappingResourceHolder.class).values();
    }

    public void configure(MappingResourceHolder configuration) {
        if (configuration.getMappingResources() != null) {
            this.mappingService.setMappingResources(configuration.getMappingResources());
            LOG.debug("Mapping scripts added {}", (Object)configuration);
        }
    }

    public SpringBidiMappingService getMappingService() {
        return this.mappingService;
    }

    public void setMappingService(SpringBidiMappingService mappingService) {
        this.mappingService = mappingService;
    }
}

