/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.spring.map.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.openehealth.ipf.commons.spring.map.MappingResourceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class CustomMappings
implements MappingResourceHolder {
    private static final Logger LOG = LoggerFactory.getLogger(CustomMappings.class);
    private Collection<Resource> mappingResources = new ArrayList<Resource>();

    @Override
    public Collection<? extends Resource> getMappingResources() {
        return this.mappingResources;
    }

    @Override
    public void setMappingResources(Collection<? extends Resource> mappingResources) {
        this.mappingResources = new ArrayList<Resource>(mappingResources.size());
        for (Resource resource : mappingResources) {
            if (resource.exists() && resource.isReadable()) {
                this.mappingResources.add(resource);
                continue;
            }
            LOG.warn("Could not read mapping script {}", (Object)resource.getFilename());
        }
    }

    @Override
    public void setMappingResource(Resource mappingResource) {
        this.setMappingResources(Collections.singleton(mappingResource));
    }
}

