/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.map;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.openehealth.ipf.commons.map.BidiMappingService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidiMappingServiceOsgiConfigurer
implements BundleListener {
    static Logger LOG = LoggerFactory.getLogger(BidiMappingServiceOsgiConfigurer.class);
    private BidiMappingService service;
    private BundleContext context;
    static String MAPPING_PATH = "META-INF/map";
    static String MAPPING_FILE = "*.map";

    public BidiMappingServiceOsgiConfigurer(BidiMappingService service, BundleContext context) {
        this.service = service;
        this.context = context;
        context.addBundleListener((BundleListener)this);
        this.initMappings();
    }

    public void bundleChanged(BundleEvent event) {
        try {
            Bundle bundle = event.getBundle();
            if (event.getType() == 32) {
                this.activateMapping(bundle);
            }
        }
        catch (Throwable e) {
            LOG.error("Exception occured during bundleChanged for event: " + event, e);
        }
    }

    public void initMappings() {
        for (Bundle bundle : this.context.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16) continue;
            this.activateMapping(bundle);
        }
        LOG.debug("initialized mapping service extender");
    }

    public void activateMapping(Bundle bundle) {
        Enumeration entries = bundle.findEntries(MAPPING_PATH, MAPPING_FILE, false);
        if (entries == null) {
            return;
        }
        ArrayList<URL> urlResources = new ArrayList<URL>();
        while (entries.hasMoreElements()) {
            URL url = (URL)entries.nextElement();
            urlResources.add(url);
        }
        URL[] resources = urlResources.toArray(new URL[urlResources.size()]);
        if (resources.length > 0) {
            this.service.setMappingScripts(resources);
            for (URL resource : resources) {
                LOG.info("Added mapping resource {} to mapping service", (Object)resource);
            }
            LOG.debug("Current mappings: {}", (Object)this.service.getReverseMap());
        }
    }
}

