/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openehealth.ipf.commons.core.config.OrderedConfigurer;
import org.openehealth.ipf.commons.core.config.Registry;
import org.openehealth.ipf.commons.core.config.SpringRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class SpringConfigurationPostProcessor
implements ApplicationListener<ContextRefreshedEvent> {
    private static Logger LOG = LoggerFactory.getLogger(SpringConfigurationPostProcessor.class);
    private boolean refreshed;
    private boolean restartOnce = true;
    private List<OrderedConfigurer> springConfigurers;

    protected void configure(Registry registry) {
        for (OrderedConfigurer sc : this.springConfigurers) {
            Collection configurations = sc.lookup(registry);
            if (configurations == null || configurations.size() <= 0) continue;
            for (Object configuration : configurations) {
                LOG.debug("Configuring extension {}", configuration);
                try {
                    sc.configure(configuration);
                }
                catch (Exception e) {
                    throw new BeanInitializationException("Cannot initialize " + configuration, (Throwable)e);
                }
            }
        }
    }

    public void setRestartOnce(boolean restartOnce) {
        this.restartOnce = restartOnce;
    }

    public List<OrderedConfigurer> getSpringConfigurers() {
        return this.springConfigurers;
    }

    public void setSpringConfigurers(List<OrderedConfigurer> springConfigurers) {
        this.springConfigurers = springConfigurers;
        Collections.sort(springConfigurers);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.refreshed || !this.restartOnce) {
            SpringRegistry registry = new SpringRegistry();
            registry.setBeanFactory((BeanFactory)event.getApplicationContext());
            if (this.getSpringConfigurers() == null) {
                LOG.info("No extension beans configured, will look up registry for extension beans");
                this.springConfigurers = new ArrayList<OrderedConfigurer>(registry.beans(OrderedConfigurer.class).values());
                Collections.sort(this.springConfigurers);
            }
            LOG.info("Number of extension beans: " + this.springConfigurers.size());
            this.configure(registry);
            this.refreshed = true;
        } else {
            LOG.info("Spring context has already been initialized before");
        }
    }
}

