/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.core.config;

import java.lang.reflect.Proxy;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.util.Assert;

final class ProxyUtils {
    ProxyUtils() {
    }

    static boolean isJDKDynamicProxy(Class<?> beanClass) {
        return Proxy.isProxyClass(beanClass);
    }

    static <T> Class<T> getFirstProxiedInterface(Class<?> proxyClass) {
        int nonUserInterfaceCount = 0;
        if (proxyClass.isAssignableFrom(SpringProxy.class)) {
            ++nonUserInterfaceCount;
        }
        if (proxyClass.isAssignableFrom(Advised.class)) {
            ++nonUserInterfaceCount;
        }
        Class<?>[] proxyInterfaces = proxyClass.getInterfaces();
        Object[] userInterfaces = new Class[proxyInterfaces.length - nonUserInterfaceCount];
        System.arraycopy(proxyInterfaces, 0, userInterfaces, 0, userInterfaces.length);
        Assert.notEmpty((Object[])userInterfaces, (String)"JDK proxy must implement one or more interfaces");
        return userInterfaces[0];
    }
}

