/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xua;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.AbstractAuditInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.XuaProcessor;
import org.openehealth.ipf.commons.ihe.ws.utils.SoapUtils;
import org.openhealthtools.ihe.atna.auditor.models.rfc3881.CodedValueType;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BasicXuaProcessor
implements XuaProcessor {
    private static final Logger log = LoggerFactory.getLogger(BasicXuaProcessor.class);
    public static final String XUA_SAML_ASSERTION = AbstractAuditInterceptor.class.getName() + ".XUA_SAML_ASSERTION";
    public static final Set<String> WSSE_NS_URIS = new HashSet<String>(Arrays.asList("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd"));
    public static final String PURPOSE_OF_USE_ATTRIBUTE_NAME = "urn:oasis:names:tc:xspa:1.0:subject:purposeofuse";
    public static final String SUBJECT_ROLE_ATTRIBUTE_NAME = "urn:oasis:names:tc:xacml:2.0:subject:role";
    public static final String PATIENT_ID_ATTRIBUTE_NAME = "urn:oasis:names:tc:xacml:2.0:resource:resource-id";
    public static final QName PURPOSE_OF_USE_ELEMENT_NAME = new QName("urn:hl7-org:v3", "PurposeOfUse");
    public static final QName SUBJECT_ROLE_ELEMENT_NAME = new QName("urn:hl7-org:v3", "Role");
    private static final UnmarshallerFactory SAML_UNMARSHALLER_FACTORY;

    private static Element extractAssertionElementFromCxfMessage(SoapMessage message, Header.Direction headerDirection) {
        Header header = message.getHeader(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        if (header == null || !headerDirection.equals((Object)header.getDirection()) || !(header.getObject() instanceof Element)) {
            return null;
        }
        Element headerElem = (Element)header.getObject();
        NodeList nodeList = headerElem.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        return (Element)nodeList.item(0);
    }

    private static Element extractAssertionElementFromDom(SoapMessage message) {
        Document document = (Document)message.getContent(Node.class);
        if (document == null) {
            return null;
        }
        Element element = SoapUtils.getElementNS((Element)document.getDocumentElement(), (Set)SoapUtils.SOAP_NS_URIS, (String)"Header");
        element = SoapUtils.getElementNS((Element)element, WSSE_NS_URIS, (String)"Security");
        return SoapUtils.getElementNS((Element)element, Collections.singleton("urn:oasis:names:tc:SAML:2.0:assertion"), (String)"Assertion");
    }

    public void extractXuaUserNameFromSaml2Assertion(SoapMessage message, Header.Direction headerDirection, WsAuditDataset auditDataset) {
        String issuer;
        Assertion assertion = null;
        Object o = message.getContextualProperty(XUA_SAML_ASSERTION);
        if (o instanceof Assertion) {
            assertion = (Assertion)o;
        }
        if (assertion == null) {
            Element assertionElem = BasicXuaProcessor.extractAssertionElementFromCxfMessage(message, headerDirection);
            if (assertionElem == null) {
                assertionElem = BasicXuaProcessor.extractAssertionElementFromDom(message);
            }
            if (assertionElem == null) {
                return;
            }
            Unmarshaller unmarshaller = SAML_UNMARSHALLER_FACTORY.getUnmarshaller(assertionElem);
            try {
                assertion = (Assertion)unmarshaller.unmarshall(assertionElem);
            }
            catch (UnmarshallingException e) {
                log.warn("Cannot extract SAML assertion from the WS-Security SOAP header", (Throwable)e);
                return;
            }
            message.getExchange().put((Object)XUA_SAML_ASSERTION, (Object)assertion);
        }
        String userName = assertion.getSubject() != null && assertion.getSubject().getNameID() != null ? assertion.getSubject().getNameID().getValue() : null;
        String string = issuer = assertion.getIssuer() != null ? assertion.getIssuer().getValue() : null;
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{issuer, userName})) {
            String spProvidedId = StringUtils.stripToEmpty((String)assertion.getSubject().getNameID().getSPProvidedID());
            auditDataset.setUserName(spProvidedId + '<' + userName + '@' + issuer + '>');
        }
        for (AttributeStatement statement : assertion.getAttributeStatements()) {
            for (Attribute attribute : statement.getAttributes()) {
                List attributeValues;
                if (PURPOSE_OF_USE_ATTRIBUTE_NAME.equals(attribute.getName())) {
                    BasicXuaProcessor.extractCodes(attribute, PURPOSE_OF_USE_ELEMENT_NAME, auditDataset.getPurposesOfUse());
                    continue;
                }
                if (SUBJECT_ROLE_ATTRIBUTE_NAME.equals(attribute.getName())) {
                    BasicXuaProcessor.extractCodes(attribute, SUBJECT_ROLE_ELEMENT_NAME, auditDataset.getUserRoles());
                    continue;
                }
                if (!PATIENT_ID_ATTRIBUTE_NAME.equals(attribute.getName()) || (attributeValues = attribute.getAttributeValues()) == null || attributeValues.isEmpty() || attributeValues.get(0) == null || ((XMLObject)attributeValues.get(0)).getDOM() == null) continue;
                auditDataset.setXuaPatientId(((XMLObject)attributeValues.get(0)).getDOM().getTextContent());
            }
        }
    }

    private static void extractCodes(Attribute attribute, QName valueElementName, List<CodedValueType> targetCollection) {
        for (XMLObject value : attribute.getAttributeValues()) {
            if (value.getDOM() == null) continue;
            NodeList nodeList = value.getDOM().getElementsByTagNameNS(valueElementName.getNamespaceURI(), valueElementName.getLocalPart());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element elem = (Element)nodeList.item(i);
                targetCollection.add(BasicXuaProcessor.elementToCode(elem));
            }
        }
    }

    private static CodedValueType elementToCode(Element element) {
        CodedValueType cvt = new CodedValueType();
        cvt.setCode(element.getAttribute("code"));
        cvt.setCodeSystemName(element.getAttribute("codeSystem"));
        cvt.setOriginalText(element.getAttribute("displayName"));
        return cvt;
    }

    static {
        try {
            InitializationService.initialize();
            XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
            SAML_UNMARSHALLER_FACTORY = registry.getUnmarshallerFactory();
        }
        catch (InitializationException e) {
            throw new RuntimeException(e);
        }
    }
}

