/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xua;

import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.AbstractAuditInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.XuaProcessor;
import org.openhealthtools.ihe.atna.auditor.models.rfc3881.CodedValueType;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BasicXuaProcessor
implements XuaProcessor {
    private static final Logger log = LoggerFactory.getLogger(BasicXuaProcessor.class);
    public static final String XUA_SAML_ASSERTION = AbstractAuditInterceptor.class.getName() + ".XUA_SAML_ASSERTION";
    public static final String WSSE_NS_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String PURPOSE_OF_USE_URI = "urn:oasis:names:tc:xspa:1.0:subject:purposeofuse";
    private static final UnmarshallerFactory SAML_UNMARSHALLER_FACTORY;

    public void extractXuaUserNameFromSaml2Assertion(SoapMessage message, Header.Direction headerDirection, WsAuditDataset auditDataset) {
        String issuer;
        Assertion assertion = null;
        Object o = message.getContextualProperty(XUA_SAML_ASSERTION);
        if (o instanceof Assertion) {
            assertion = (Assertion)o;
        }
        if (assertion == null) {
            Header header = message.getHeader(new QName(WSSE_NS_URI, "Security"));
            if (header == null || !headerDirection.equals((Object)header.getDirection()) || !(header.getObject() instanceof Element)) {
                return;
            }
            Element headerElem = (Element)header.getObject();
            NodeList nodeList = headerElem.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
            Element assertionElem = (Element)nodeList.item(0);
            if (assertionElem == null) {
                return;
            }
            Unmarshaller unmarshaller = SAML_UNMARSHALLER_FACTORY.getUnmarshaller(assertionElem);
            try {
                assertion = (Assertion)unmarshaller.unmarshall(assertionElem);
            }
            catch (UnmarshallingException e) {
                log.warn("Cannot extract SAML assertion from the WS-Security SOAP header", (Throwable)e);
                return;
            }
            message.getExchange().put((Object)XUA_SAML_ASSERTION, (Object)assertion);
        }
        String userName = assertion.getSubject() != null && assertion.getSubject().getNameID() != null ? assertion.getSubject().getNameID().getValue() : null;
        String string = issuer = assertion.getIssuer() != null ? assertion.getIssuer().getValue() : null;
        if (StringUtils.isNotEmpty((CharSequence)issuer) && StringUtils.isNotEmpty((CharSequence)userName)) {
            auditDataset.setUserName(assertion.getSubject().getNameID().getSPProvidedID() + '<' + userName + '@' + issuer + '>');
        }
        for (AttributeStatement statement : assertion.getAttributeStatements()) {
            for (Attribute attribute : statement.getAttributes()) {
                if (!PURPOSE_OF_USE_URI.equals(attribute.getName())) continue;
                for (XMLObject value : attribute.getAttributeValues()) {
                    NodeList purposeElemList = value.getDOM().getElementsByTagNameNS("urn:hl7-org:v3", "PurposeOfUse");
                    for (int i = 0; i < purposeElemList.getLength(); ++i) {
                        Element purposeElem = (Element)purposeElemList.item(i);
                        CodedValueType cvt = new CodedValueType();
                        cvt.setCode(purposeElem.getAttribute("code"));
                        cvt.setCodeSystemName(purposeElem.getAttribute("codeSystem"));
                        cvt.setOriginalText(purposeElem.getAttribute("displayName"));
                        auditDataset.getPurposesOfUse().add(cvt);
                    }
                }
            }
        }
    }

    static {
        try {
            InitializationService.initialize();
            XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
            SAML_UNMARSHALLER_FACTORY = registry.getUnmarshallerFactory();
        }
        catch (InitializationException e) {
            throw new RuntimeException(e);
        }
    }
}

