/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xacml20.iti79;

import java.util.Collections;
import java.util.Map;
import org.herasaf.xacml.core.context.impl.AttributeType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.context.impl.SubjectType;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCodeRole;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.ParticipantObjectIdType;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategySupport;
import org.openehealth.ipf.commons.ihe.core.atna.event.QueryInformationBuilder;
import org.openehealth.ipf.commons.ihe.xacml20.Xacml20Status;
import org.openehealth.ipf.commons.ihe.xacml20.Xacml20Utils;
import org.openehealth.ipf.commons.ihe.xacml20.audit.codes.Xacml20EventTypeCodes;
import org.openehealth.ipf.commons.ihe.xacml20.audit.codes.Xacml20ParticipantIdType;
import org.openehealth.ipf.commons.ihe.xacml20.iti79.Iti79AuditDataset;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.protocol.ResponseType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.protocol.XACMLAuthzDecisionQueryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Iti79AuditStrategy
extends AuditStrategySupport<Iti79AuditDataset> {
    private static final Logger log = LoggerFactory.getLogger(Iti79AuditStrategy.class);

    public Iti79AuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    public Iti79AuditDataset createAuditDataset() {
        return new Iti79AuditDataset(this.isServerSide());
    }

    public AuditMessage[] makeAuditMessage(AuditContext auditContext, Iti79AuditDataset auditDataset) {
        QueryInformationBuilder builder = new QueryInformationBuilder(auditContext, (AuditDataset)auditDataset, (EventType)Xacml20EventTypeCodes.AuthorizationDecisionsQueryIhe, auditDataset.getPurposesOfUse());
        return ((QueryInformationBuilder)builder.setQueryParameters(auditDataset.getRequesterId(), (ParticipantObjectIdType)Xacml20ParticipantIdType.AuthorizationDecisionsQueryIhe, null, ParticipantObjectTypeCode.Person, ParticipantObjectTypeCodeRole.SecurityUserEntity, Collections.emptyList()).setQueryParameters(auditDataset.getQueryId(), (ParticipantObjectIdType)Xacml20ParticipantIdType.AuthorizationDecisionsQueryIhe, auditDataset.getRequestPayload(), Collections.emptyList()).addSecurityResourceParticipantObject((ParticipantObjectIdType)Xacml20ParticipantIdType.AuthorizationDecisionsQueryIhe, auditDataset.getStatusCode())).getMessages();
    }

    public Iti79AuditDataset enrichAuditDatasetFromRequest(Iti79AuditDataset auditDataset, Object requestObject, Map<String, Object> parameters) {
        XACMLAuthzDecisionQueryType query = (XACMLAuthzDecisionQueryType)requestObject;
        RequestType request = Xacml20Utils.extractAuthzRequest(query);
        for (AttributeType attribute : ((SubjectType)request.getSubjects().get(0)).getAttributes()) {
            if (!"urn:oasis:names:tc:xacml:1.0:subject:subject-id".equals(attribute.getAttributeId())) continue;
            auditDataset.setRequesterId(Xacml20Utils.extractStringAttributeValue(attribute));
        }
        auditDataset.setQueryId(query.getID());
        return auditDataset;
    }

    public boolean enrichAuditDatasetFromResponse(Iti79AuditDataset auditDataset, Object responseObject, AuditContext auditContext) {
        try {
            ResponseType response = (ResponseType)responseObject;
            String statusCode = response.getStatus().getStatusCode().getValue();
            auditDataset.setStatusCode(statusCode);
            if (Xacml20Status.SUCCESS.getCode().equals(statusCode)) {
                auditDataset.setEventOutcomeIndicator(EventOutcomeIndicator.Success);
            } else {
                auditDataset.setEventOutcomeIndicator(EventOutcomeIndicator.SeriousFailure);
            }
        }
        catch (Exception e) {
            auditDataset.setEventOutcomeIndicator(EventOutcomeIndicator.MajorFailure);
        }
        return super.enrichAuditDatasetFromResponse((AuditDataset)auditDataset, responseObject, auditContext);
    }
}

