/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xacml20;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.herasaf.xacml.core.context.impl.AttributeType;
import org.herasaf.xacml.core.context.impl.AttributeValueType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.context.impl.ResourceType;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.impl.IdReferenceType;
import org.herasaf.xacml.core.simplePDP.initializers.InitializerExecutor;
import org.herasaf.xacml.core.simplePDP.initializers.api.Initializer;
import org.openehealth.ipf.commons.ihe.xacml20.herasaf.Hl7v3DataTypesInitializer;
import org.openehealth.ipf.commons.ihe.xacml20.herasaf.Hl7v3FunctionsInitializer;
import org.openehealth.ipf.commons.ihe.xacml20.herasaf.types.IiDataTypeAttribute;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.AddPolicyRequest;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.AssertionBasedRequestType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.DeletePolicyRequest;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.UpdatePolicyRequest;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.XACMLPolicySetIdReferenceStatementType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.hl7v3.CV;
import org.openehealth.ipf.commons.ihe.xacml20.stub.hl7v3.II;
import org.openehealth.ipf.commons.ihe.xacml20.stub.hl7v3.ObjectFactory;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.AssertionType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.StatementAbstractType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.protocol.ResponseType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.assertion.XACMLPolicyStatementType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.protocol.XACMLAuthzDecisionQueryType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.protocol.XACMLPolicyQueryType;

public class Xacml20Utils {
    public static final String ATTRIBUTE_TYPE_PATIENT_ID = "urn:e-health-suisse:2015:epr-spid";
    public static final String ELEMENT_NAME_PATIENT_ID = "InstanceIdentifier";
    public static final QName QUERY_REQUEST_QNAME = new QName("urn:oasis:names:tc:xacml:2.0:context:schema:os", "Request");
    public static final QName QUERY_POLICY_ID_QNAME = new QName("urn:oasis:names:tc:xacml:2.0:policy:schema:os", "PolicyIdReference");
    public static final QName QUERY_POLICY_SET_ID_QNAME = new QName("urn:oasis:names:tc:xacml:2.0:policy:schema:os", "PolicySetIdReference");
    public static final JAXBContext JAXB_CONTEXT;

    public static void initializeHerasaf(Initializer ... customInitializers) {
        HashSet<Object> initializers = new HashSet<Object>(InitializerExecutor.getDefaultInitializers());
        initializers.add((Object)new Hl7v3DataTypesInitializer());
        initializers.add((Object)new Hl7v3FunctionsInitializer());
        initializers.addAll(Arrays.asList(customInitializers));
        InitializerExecutor.setInitalizers(initializers);
        InitializerExecutor.runInitializers();
    }

    public static Stream<Evaluatable> toStream(ResponseType response) {
        Stream<Evaluatable> result = Stream.of(new Evaluatable[0]);
        if (response != null) {
            for (Object object : response.getAssertionOrEncryptedAssertion()) {
                if (!(object instanceof AssertionType)) continue;
                AssertionType assertion = (AssertionType)object;
                for (StatementAbstractType statement : assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement()) {
                    if (!(statement instanceof XACMLPolicyStatementType)) continue;
                    XACMLPolicyStatementType policyStatement = (XACMLPolicyStatementType)statement;
                    result = Stream.concat(result, policyStatement.getPolicyOrPolicySet().stream().map(x -> (Evaluatable)x));
                }
            }
        }
        return result;
    }

    private static Stream<Evaluatable> toStream(AssertionBasedRequestType request) {
        Stream<Evaluatable> result = Stream.of(new Evaluatable[0]);
        if (request != null) {
            for (StatementAbstractType abstractStatement : request.getAssertion().getStatementOrAuthnStatementOrAuthzDecisionStatement()) {
                if (!(abstractStatement instanceof XACMLPolicyStatementType)) continue;
                XACMLPolicyStatementType policyStatement = (XACMLPolicyStatementType)abstractStatement;
                result = Stream.concat(result, policyStatement.getPolicyOrPolicySet().stream().map(x -> (Evaluatable)x));
            }
        }
        return result;
    }

    public static Stream<Evaluatable> toStream(AddPolicyRequest request) {
        return Xacml20Utils.toStream((AssertionBasedRequestType)request);
    }

    public static Stream<Evaluatable> toStream(UpdatePolicyRequest request) {
        return Xacml20Utils.toStream((AssertionBasedRequestType)request);
    }

    public static Stream<IdReferenceType> toStream(DeletePolicyRequest request) {
        Stream<IdReferenceType> result = Stream.of(new IdReferenceType[0]);
        if (request != null && request.getAssertion() != null) {
            for (StatementAbstractType abstractStatement : request.getAssertion().getStatementOrAuthnStatementOrAuthzDecisionStatement()) {
                if (!(abstractStatement instanceof XACMLPolicySetIdReferenceStatementType)) continue;
                XACMLPolicySetIdReferenceStatementType xacmlStatement = (XACMLPolicySetIdReferenceStatementType)abstractStatement;
                result = Stream.concat(result, xacmlStatement.getPolicySetIdReference().stream());
            }
        }
        return result;
    }

    public static Optional<String> extractPatientId(XACMLPolicyQueryType request) {
        for (JAXBElement<?> jaxbElement : request.getRequestOrPolicySetIdReferenceOrPolicyIdReference()) {
            if (!QUERY_REQUEST_QNAME.equals(jaxbElement.getName()) || !(jaxbElement.getValue() instanceof RequestType)) continue;
            RequestType requestType = (RequestType)jaxbElement.getValue();
            for (ResourceType resourceType : requestType.getResources()) {
                for (AttributeType attributeType : resourceType.getAttributes()) {
                    if (!ATTRIBUTE_TYPE_PATIENT_ID.equals(attributeType.getAttributeId()) || !(attributeType.getDataType() instanceof IiDataTypeAttribute)) continue;
                    for (AttributeValueType attributeValueType : attributeType.getAttributeValues()) {
                        for (Object valueObject : attributeValueType.getContent()) {
                            JAXBElement jaxbElement1;
                            if (!(valueObject instanceof JAXBElement) || !ELEMENT_NAME_PATIENT_ID.equals((jaxbElement1 = (JAXBElement)valueObject).getName().getLocalPart()) || !(jaxbElement1.getValue() instanceof II)) continue;
                            II ii = (II)jaxbElement1.getValue();
                            String root = StringUtils.trimToEmpty((String)ii.getRoot());
                            String extension = StringUtils.trimToEmpty((String)ii.getExtension());
                            return Optional.of(extension + "^^^&" + root + "&ISO");
                        }
                    }
                }
            }
        }
        return Optional.empty();
    }

    public static Optional<IdReferenceType> extractPolicyId(XACMLPolicyQueryType request) {
        for (JAXBElement<?> jaxbElement : request.getRequestOrPolicySetIdReferenceOrPolicyIdReference()) {
            if (!QUERY_POLICY_SET_ID_QNAME.equals(jaxbElement.getName()) && !QUERY_POLICY_ID_QNAME.equals(jaxbElement.getName()) || !(jaxbElement.getValue() instanceof IdReferenceType)) continue;
            return Optional.of((IdReferenceType)jaxbElement.getValue());
        }
        return Optional.empty();
    }

    public static RequestType extractAuthzRequest(XACMLAuthzDecisionQueryType query) {
        for (JAXBElement<?> jaxbElement : query.getRest()) {
            if (!(jaxbElement.getValue() instanceof RequestType)) continue;
            return (RequestType)jaxbElement.getValue();
        }
        throw new IllegalArgumentException("Could not extract authorization request");
    }

    public static String extractStringAttributeValue(AttributeType attribute) {
        try {
            return (String)((AttributeValueType)attribute.getAttributeValues().get(0)).getContent().get(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CV extractCodeAttributeValue(AttributeType attribute) {
        try {
            for (Object o : ((AttributeValueType)attribute.getAttributeValues().get(0)).getContent()) {
                Object value;
                if (!(o instanceof JAXBElement) || !((value = ((JAXBElement)o).getValue()) instanceof CV)) continue;
                return (CV)value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.ObjectFactory.class, org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.ObjectFactory.class, org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.protocol.ObjectFactory.class, org.herasaf.xacml.core.policy.impl.ObjectFactory.class, org.herasaf.xacml.core.context.impl.ObjectFactory.class, org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.protocol.ObjectFactory.class, org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.assertion.ObjectFactory.class, ObjectFactory.class, org.apache.xml.security.binding.xmlenc.ObjectFactory.class, org.apache.xml.security.binding.xmldsig.ObjectFactory.class, org.apache.xml.security.binding.xop.ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

