/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xacml20;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.util.JAXBSource;
import java.util.Map;
import javax.xml.transform.Source;
import org.openehealth.ipf.commons.core.modules.api.ValidationException;
import org.openehealth.ipf.commons.ihe.xacml20.Xacml20Utils;
import org.openehealth.ipf.commons.ihe.xacml20.chppq1.ChPpq1RequestValidationProfile;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.EprPolicyRepositoryResponse;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.protocol.ResponseType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.protocol.XACMLAuthzDecisionQueryType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.protocol.XACMLPolicyQueryType;
import org.openehealth.ipf.commons.xml.CombinedXmlValidationProfile;
import org.openehealth.ipf.commons.xml.CombinedXmlValidator;
import org.openehealth.ipf.commons.xml.XmlUtils;
import org.openehealth.ipf.commons.xml.XsdValidator;

public class Xacml20MessageValidator {
    private static final XsdValidator XSD_VALIDATOR = new XsdValidator();
    private static final CombinedXmlValidator COMBINED_XML_VALIDATOR = new CombinedXmlValidator();
    private static final Map<Class<?>, String> XML_SCHEMAS = Map.of(XACMLPolicyQueryType.class, "schema/xacml-2.0-profile-saml2.0-v2-schema-protocol-wd-14.xsd", XACMLAuthzDecisionQueryType.class, "schema/xacml-2.0-profile-saml2.0-v2-schema-protocol-wd-14.xsd", ResponseType.class, "schema/PolicyQueryResponse.xsd", EprPolicyRepositoryResponse.class, "schema/epr-policy-administration-combined-schema-1.3-local.xsd");

    private static void validateMessage(Object message) {
        try {
            JAXBSource source = new JAXBSource(Xacml20Utils.JAXB_CONTEXT, message);
            XSD_VALIDATOR.validate((Source)source, XML_SCHEMAS.get(message.getClass()));
        }
        catch (JAXBException e) {
            throw new ValidationException((Throwable)e);
        }
    }

    public static void validateChPpq1Request(Object request) {
        String s = XmlUtils.renderJaxb((JAXBContext)Xacml20Utils.JAXB_CONTEXT, (Object)request, (Boolean)false);
        COMBINED_XML_VALIDATOR.validate(s, (CombinedXmlValidationProfile)new ChPpq1RequestValidationProfile());
    }

    public static void validateChPpq2Request(XACMLPolicyQueryType message) {
        Xacml20MessageValidator.validateMessage(message);
    }

    public static void validateIti79Request(XACMLAuthzDecisionQueryType message) {
        Xacml20MessageValidator.validateMessage(message);
    }

    public static void validateChAdrRequest(XACMLAuthzDecisionQueryType message) {
        Xacml20MessageValidator.validateMessage(message);
    }

    public static void validateChPpq1Response(EprPolicyRepositoryResponse message) {
        Xacml20MessageValidator.validateMessage(message);
    }

    public static void validateQueryResponse(ResponseType message) {
        Xacml20MessageValidator.validateMessage(message);
    }
}

