/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xacml20.chppq1;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBElement;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategySupport;
import org.openehealth.ipf.commons.ihe.xacml20.Xacml20Utils;
import org.openehealth.ipf.commons.ihe.xacml20.audit.ChPpqAuditDataset;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.AddPolicyRequest;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.DeletePolicyRequest;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.EprPolicyRepositoryResponse;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.UpdatePolicyRequest;
import org.openehealth.ipf.commons.ihe.xacml20.stub.hl7v3.II;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChPpq1AuditStrategy
extends AuditStrategySupport<ChPpqAuditDataset> {
    private static final Logger log = LoggerFactory.getLogger(ChPpq1AuditStrategy.class);

    public ChPpq1AuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    public ChPpqAuditDataset createAuditDataset() {
        return new ChPpqAuditDataset(this.isServerSide());
    }

    public ChPpqAuditDataset enrichAuditDatasetFromRequest(ChPpqAuditDataset auditDataset, Object request, Map<String, Object> parameters) {
        if (request instanceof AddPolicyRequest) {
            auditDataset.setAction(EventActionCode.Create);
            Xacml20Utils.toStream((AddPolicyRequest)request).forEach(policy -> auditDataset.getPolicyAndPolicySetIds().add(policy.getId().toString()));
            auditDataset.setPatientId(this.extractPatientIdFromPolicy(Xacml20Utils.toStream((AddPolicyRequest)request)));
        } else if (request instanceof UpdatePolicyRequest) {
            auditDataset.setAction(EventActionCode.Update);
            Xacml20Utils.toStream((UpdatePolicyRequest)request).forEach(policy -> auditDataset.getPolicyAndPolicySetIds().add(policy.getId().toString()));
            auditDataset.setPatientId(this.extractPatientIdFromPolicy(Xacml20Utils.toStream((UpdatePolicyRequest)request)));
        } else if (request instanceof DeletePolicyRequest) {
            auditDataset.setAction(EventActionCode.Delete);
            Xacml20Utils.toStream((DeletePolicyRequest)request).forEach(id -> auditDataset.getPolicyAndPolicySetIds().add(id.getValue()));
            auditDataset.setPatientId(auditDataset.getXuaPatientId());
        } else {
            log.warn("Enrichment if audit data set failed due to unknown input type: '{}'", (Object)request.getClass().getName());
        }
        return auditDataset;
    }

    public boolean enrichAuditDatasetFromResponse(ChPpqAuditDataset auditDataset, Object response, AuditContext auditContext) {
        auditDataset.setEventOutcomeIndicator(this.getEventOutcomeIndicator(auditDataset, response));
        return true;
    }

    public EventOutcomeIndicator getEventOutcomeIndicator(ChPpqAuditDataset auditDataset, Object responseObject) {
        EprPolicyRepositoryResponse response = (EprPolicyRepositoryResponse)responseObject;
        return "urn:e-health-suisse:2015:response-status:success".equals(response.getStatus()) ? EventOutcomeIndicator.Success : EventOutcomeIndicator.SeriousFailure;
    }

    private String extractPatientIdFromPolicy(Stream<Evaluatable> policyOrPolicySets) {
        Set eprSpids = policyOrPolicySets.flatMap(evaluatable -> evaluatable.getTarget().getResources().getResources().stream()).flatMap(resourceType -> resourceType.getResourceMatches().stream()).filter(resourceMatchType -> resourceMatchType.getMatchFunction().getFunctionId().equals("urn:hl7-org:v3:function:II-equal") && resourceMatchType.getResourceAttributeDesignator().getAttributeId().equals("urn:e-health-suisse:2015:epr-spid")).map(resourceMatchType -> resourceMatchType.getAttributeValue().getContent().stream().filter(JAXBElement.class::isInstance).findFirst().orElseThrow(() -> new IllegalArgumentException("AttributeValue is empty."))).map(o -> (II)((JAXBElement)o).getValue()).map(ii -> String.format("%s^^^&%s&ISO", ii.getExtension(), ii.getRoot())).collect(Collectors.toSet());
        if (eprSpids.size() > 1) {
            throw new IllegalArgumentException(String.format("Policies for more than one patient are being fed in a single submission. This is not legal. EPR-SPIDs: %s", eprSpids));
        }
        return eprSpids.stream().findFirst().orElse(null);
    }
}

