/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xacml20.chadr;

import java.util.Collections;
import java.util.Map;
import org.herasaf.xacml.core.context.impl.AttributeType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.context.impl.ResourceType;
import org.herasaf.xacml.core.context.impl.ResultType;
import org.herasaf.xacml.core.context.impl.SubjectType;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCodeRole;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.model.TypeValuePairType;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.ParticipantObjectIdType;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategySupport;
import org.openehealth.ipf.commons.ihe.core.atna.event.QueryInformationBuilder;
import org.openehealth.ipf.commons.ihe.xacml20.Xacml20Status;
import org.openehealth.ipf.commons.ihe.xacml20.Xacml20Utils;
import org.openehealth.ipf.commons.ihe.xacml20.audit.codes.Xacml20EventTypeCodes;
import org.openehealth.ipf.commons.ihe.xacml20.audit.codes.Xacml20ParticipantIdType;
import org.openehealth.ipf.commons.ihe.xacml20.chadr.ChAdrAuditDataset;
import org.openehealth.ipf.commons.ihe.xacml20.stub.hl7v3.CV;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.AssertionType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.protocol.ResponseType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.assertion.XACMLAuthzDecisionStatementType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.protocol.XACMLAuthzDecisionQueryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChAdrAuditStrategy
extends AuditStrategySupport<ChAdrAuditDataset> {
    private static final Logger log = LoggerFactory.getLogger(ChAdrAuditStrategy.class);

    public ChAdrAuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    public ChAdrAuditDataset createAuditDataset() {
        return new ChAdrAuditDataset(this.isServerSide());
    }

    public AuditMessage[] makeAuditMessage(AuditContext auditContext, ChAdrAuditDataset auditDataset) {
        QueryInformationBuilder builder = new QueryInformationBuilder(auditContext, (AuditDataset)auditDataset, (EventType)Xacml20EventTypeCodes.AuthorizationDecisionsQueryAdr, auditDataset.getPurposesOfUse());
        builder.setQueryParameters(auditDataset.getSubjectId(), auditDataset.getSubjectRole(), null, ParticipantObjectTypeCode.Person, ParticipantObjectTypeCodeRole.SecurityUserEntity, Collections.emptyList());
        for (Map.Entry<String, String> entry : auditDataset.getDecisionsByResourceIds().entrySet()) {
            builder.setQueryParameters(entry.getKey(), (ParticipantObjectIdType)Xacml20ParticipantIdType.AuthorizationDecisionsQueryAdr, null, ParticipantObjectTypeCode.System, auditDataset.getObjectRole(), entry.getValue() != null ? Collections.singletonList(new TypeValuePairType("decision", entry.getValue())) : Collections.emptyList());
        }
        return builder.getMessages();
    }

    public ChAdrAuditDataset enrichAuditDatasetFromRequest(ChAdrAuditDataset auditDataset, Object requestObject, Map<String, Object> parameters) {
        XACMLAuthzDecisionQueryType query = (XACMLAuthzDecisionQueryType)requestObject;
        RequestType authzRequest = Xacml20Utils.extractAuthzRequest(query);
        for (AttributeType attribute : ((SubjectType)authzRequest.getSubjects().get(0)).getAttributes()) {
            switch (attribute.getAttributeId()) {
                case "urn:oasis:names:tc:xacml:1.0:subject:subject-id": {
                    auditDataset.setSubjectId(Xacml20Utils.extractStringAttributeValue(attribute));
                    break;
                }
                case "urn:oasis:names:tc:xacml:2.0:subject:role": {
                    CV cv = Xacml20Utils.extractCodeAttributeValue(attribute);
                    if (cv == null) break;
                    auditDataset.setSubjectRole(ParticipantObjectIdType.of((String)cv.getCode(), (String)cv.getCodeSystem(), (String)cv.getDisplayName()));
                }
            }
        }
        block25: for (ResourceType resource : authzRequest.getResources()) {
            for (AttributeType attribute : resource.getAttributes()) {
                if (!"urn:oasis:names:tc:xacml:1.0:resource:resource-id".equals(attribute.getAttributeId())) continue;
                String resourceId = Xacml20Utils.extractStringAttributeValue(attribute);
                auditDataset.getDecisionsByResourceIds().put(resourceId, null);
                continue block25;
            }
        }
        for (AttributeType attribute : authzRequest.getAction().getAttributes()) {
            String action;
            if (!"urn:oasis:names:tc:xacml:1.0:action:action-id".equals(attribute.getAttributeId()) || (action = Xacml20Utils.extractStringAttributeValue(attribute)) == null) continue;
            switch (action) {
                case "urn:ihe:iti:2007:RegistryStoredQuery": 
                case "urn:ihe:iti:2007:RegisterDocumentSet-b": 
                case "urn:ihe:iti:2010:UpdateDocumentSet": 
                case "urn:ihe:iti:2018:RestrictedUpdateDocumentSet": {
                    auditDataset.setObjectRole(ParticipantObjectTypeCodeRole.Report);
                    break;
                }
                case "urn:e-health-suisse:2015:policy-administration:AddPolicy": 
                case "urn:e-health-suisse:2015:policy-administration:UpdatePolicy": 
                case "urn:e-health-suisse:2015:policy-administration:DeletePolicy": 
                case "urn:e-health-suisse:2015:policy-administration:PolicyQuery": {
                    auditDataset.setObjectRole(ParticipantObjectTypeCodeRole.SecurityResource);
                    break;
                }
                case "urn:e-health-suisse:2015:patient-audit-administration:RetrieveAtnaAudit": {
                    auditDataset.setObjectRole(ParticipantObjectTypeCodeRole.DataRepository);
                }
            }
            break;
        }
        return auditDataset;
    }

    public boolean enrichAuditDatasetFromResponse(ChAdrAuditDataset auditDataset, Object responseObject, AuditContext auditContext) {
        try {
            ResponseType response = (ResponseType)responseObject;
            String statusCode = response.getStatus().getStatusCode().getValue();
            if (Xacml20Status.SUCCESS.getCode().equals(statusCode)) {
                auditDataset.setEventOutcomeIndicator(EventOutcomeIndicator.Success);
                AssertionType assertion = (AssertionType)response.getAssertionOrEncryptedAssertion().get(0);
                XACMLAuthzDecisionStatementType statement = (XACMLAuthzDecisionStatementType)assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().get(0);
                for (ResultType result : statement.getResponse().getResults()) {
                    auditDataset.getDecisionsByResourceIds().put(result.getResourceId(), result.getDecision().value());
                }
            } else {
                auditDataset.setEventOutcomeIndicator(EventOutcomeIndicator.SeriousFailure);
            }
        }
        catch (Exception e) {
            auditDataset.setEventOutcomeIndicator(EventOutcomeIndicator.MajorFailure);
        }
        return super.enrichAuditDatasetFromResponse((AuditDataset)auditDataset, responseObject, auditContext);
    }
}

