/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xacml20.chppq;

import java.io.InputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.herasaf.xacml.core.simplePDP.initializers.api.Initializer;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.openehealth.ipf.commons.ihe.xacml20.Xacml20MessageValidator;
import org.openehealth.ipf.commons.ihe.xacml20.Xacml20Utils;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.EprPolicyRepositoryResponse;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.protocol.ResponseType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.protocol.XACMLPolicyQueryType;

public class MessageValidationTest {
    @BeforeAll
    public static void beforeClass() {
        Xacml20Utils.initializeHerasaf((Initializer[])new Initializer[0]);
    }

    private static <T> T loadFile(String fn) throws Exception {
        InputStream stream = MessageValidationTest.class.getClassLoader().getResourceAsStream("messages/" + fn);
        Unmarshaller unmarshaller = Xacml20Utils.JAXB_CONTEXT.createUnmarshaller();
        Object object = unmarshaller.unmarshal(stream);
        if (object instanceof JAXBElement) {
            object = ((JAXBElement)object).getValue();
        }
        return (T)object;
    }

    @Test
    public void testValidation() throws Exception {
        Xacml20MessageValidator.validateChPpq1Request(MessageValidationTest.loadFile("chppq1/add-request-ppq.xml"));
        Xacml20MessageValidator.validateChPpq1Request(MessageValidationTest.loadFile("chppq1/update-request-ppq.xml"));
        Xacml20MessageValidator.validateChPpq1Request(MessageValidationTest.loadFile("chppq1/delete-request.xml"));
        Xacml20MessageValidator.validateChPpq1Response((EprPolicyRepositoryResponse)((EprPolicyRepositoryResponse)MessageValidationTest.loadFile("chppq1/ack.xml")));
        Xacml20MessageValidator.validateChPpq2Request((XACMLPolicyQueryType)((XACMLPolicyQueryType)MessageValidationTest.loadFile("chppq2/query-per-patient-id.xml")));
        Xacml20MessageValidator.validateChPpq2Request((XACMLPolicyQueryType)((XACMLPolicyQueryType)MessageValidationTest.loadFile("chppq2/query-per-policy-id.xml")));
        Xacml20MessageValidator.validateQueryResponse((ResponseType)((ResponseType)MessageValidationTest.loadFile("chppq2/query-response.xml")));
    }
}

