/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xacml20.chppq;

import java.io.InputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.herasaf.xacml.core.simplePDP.initializers.api.Initializer;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.openehealth.ipf.commons.ihe.xacml20.Xacml20MessageValidator;
import org.openehealth.ipf.commons.ihe.xacml20.Xacml20Utils;

public class MessageValidationTest {
    @BeforeAll
    public static void beforeClass() {
        Xacml20Utils.initializeHerasaf((Initializer[])new Initializer[0]);
    }

    private static <T> T loadFile(String fn) throws Exception {
        InputStream stream = MessageValidationTest.class.getClassLoader().getResourceAsStream("messages/" + fn);
        Unmarshaller unmarshaller = Xacml20Utils.JAXB_CONTEXT.createUnmarshaller();
        Object object = unmarshaller.unmarshal(stream);
        if (object instanceof JAXBElement) {
            object = ((JAXBElement)object).getValue();
        }
        return (T)object;
    }

    @Test
    public void testValidation() throws Exception {
        Xacml20MessageValidator.validateChPpq1Request(MessageValidationTest.loadFile("chppq1/add-request-ppq.xml"), (Class[])new Class[0]);
        Xacml20MessageValidator.validateChPpq1Request(MessageValidationTest.loadFile("chppq1/update-request-ppq.xml"), (Class[])new Class[0]);
        Xacml20MessageValidator.validateChPpq1Request(MessageValidationTest.loadFile("chppq1/delete-request.xml"), (Class[])new Class[0]);
        Xacml20MessageValidator.validateChPpq1Response(MessageValidationTest.loadFile("chppq1/ack.xml"), (Class[])new Class[0]);
        Xacml20MessageValidator.validateChPpq2Request(MessageValidationTest.loadFile("chppq2/query-per-patient-id.xml"), (Class[])new Class[0]);
        Xacml20MessageValidator.validateChPpq2Request(MessageValidationTest.loadFile("chppq2/query-per-policy-id.xml"), (Class[])new Class[0]);
        Xacml20MessageValidator.validateChPpq2Response(MessageValidationTest.loadFile("chppq2/query-response.xml"), (Class[])new Class[0]);
    }
}

