/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xacml20;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import org.apache.commons.lang3.ArrayUtils;
import org.openehealth.ipf.commons.core.modules.api.ValidationException;
import org.openehealth.ipf.commons.ihe.xacml20.Xacml20Utils;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.AddPolicyRequest;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.DeletePolicyRequest;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.EprPolicyRepositoryResponse;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.UpdatePolicyRequest;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.protocol.ResponseType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.protocol.XACMLPolicyQueryType;
import org.openehealth.ipf.commons.xml.XsdValidator;

public class Xacml20MessageValidator {
    private static final XsdValidator XSD_VALIDATOR = new XsdValidator();
    private static final Map<Class<?>, String> REQUEST_SCHEMAS = new HashMap();
    private static final Map<Class<?>, String> RESPONSE_SCHEMAS;

    private static void validateMessage(Object message, Map<Class<?>, String> schemaNames, Class ... allowedClasses) {
        if (message == null) {
            throw new ValidationException("Message cannot be <null>");
        }
        if (!ArrayUtils.contains((Object[])allowedClasses, message.getClass())) {
            throw new ValidationException("Unsupported message type " + message.getClass());
        }
        try {
            JAXBSource source = new JAXBSource(Xacml20Utils.JAXB_CONTEXT, message);
            XSD_VALIDATOR.validate((Source)source, schemaNames.get(message.getClass()));
        }
        catch (JAXBException e) {
            throw new ValidationException((Throwable)e);
        }
    }

    public static void validateChPpq1Request(Object request, Class ... allowedClasses) {
        Xacml20MessageValidator.validateMessage(request, REQUEST_SCHEMAS, AddPolicyRequest.class, UpdatePolicyRequest.class, DeletePolicyRequest.class);
    }

    public static void validateChPpq2Request(Object request, Class ... allowedClasses) {
        Xacml20MessageValidator.validateMessage(request, REQUEST_SCHEMAS, XACMLPolicyQueryType.class);
    }

    public static void validateChPpq1Response(Object request, Class ... allowedClasses) {
        Xacml20MessageValidator.validateMessage(request, RESPONSE_SCHEMAS, EprPolicyRepositoryResponse.class);
    }

    public static void validateChPpq2Response(Object request, Class ... allowedClasses) {
        Xacml20MessageValidator.validateMessage(request, RESPONSE_SCHEMAS, ResponseType.class);
    }

    static {
        REQUEST_SCHEMAS.put(XACMLPolicyQueryType.class, "schema/xacml-2.0-profile-saml2.0-v2-schema-protocol-wd-14.xsd");
        REQUEST_SCHEMAS.put(AddPolicyRequest.class, "schema/epr-policy-administration-combined-schema-1.3-local.xsd");
        REQUEST_SCHEMAS.put(UpdatePolicyRequest.class, "schema/epr-policy-administration-combined-schema-1.3-local.xsd");
        REQUEST_SCHEMAS.put(DeletePolicyRequest.class, "schema/epr-policy-administration-combined-schema-1.3-local.xsd");
        RESPONSE_SCHEMAS = new HashMap();
        RESPONSE_SCHEMAS.put(ResponseType.class, "schema/PolicyQueryResponse.xsd");
        RESPONSE_SCHEMAS.put(EprPolicyRepositoryResponse.class, "schema/epr-policy-administration-combined-schema-1.3-local.xsd");
    }
}

