/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xacml20.chppq2;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.types.CodedValueType;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.ParticipantObjectIdType;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategySupport;
import org.openehealth.ipf.commons.ihe.core.atna.event.QueryInformationBuilder;
import org.openehealth.ipf.commons.ihe.xacml20.Xacml20Utils;
import org.openehealth.ipf.commons.ihe.xacml20.audit.ChPpqAuditDataset;
import org.openehealth.ipf.commons.ihe.xacml20.audit.codes.PpqEventTypeCodes;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.protocol.ResponseType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.protocol.XACMLPolicyQueryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChPpq2AuditStrategy
extends AuditStrategySupport<ChPpqAuditDataset> {
    private static final Logger log = LoggerFactory.getLogger(ChPpq2AuditStrategy.class);

    public ChPpq2AuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    public ChPpqAuditDataset createAuditDataset() {
        return new ChPpqAuditDataset(this.isServerSide());
    }

    public AuditMessage[] makeAuditMessage(AuditContext auditContext, ChPpqAuditDataset auditDataset) {
        QueryInformationBuilder builder = new QueryInformationBuilder(auditContext, (AuditDataset)auditDataset, (EventType)PpqEventTypeCodes.PrivacyPolicyRetrieve, auditDataset.getPurposesOfUse());
        return builder.addPatients(new String[]{auditDataset.getPatientId()}).setQueryParameters(auditDataset.getQueryId(), ParticipantObjectIdType.of((CodedValueType)PpqEventTypeCodes.PrivacyPolicyRetrieve), auditDataset.getRequestPayload(), StringUtils.isNotEmpty((CharSequence)auditDataset.getRequestPayload()) ? Collections.singletonList(builder.getTypeValuePair("QueryEncoding", (Object)Charset.defaultCharset().toString())) : Collections.emptyList()).getMessages();
    }

    public ChPpqAuditDataset enrichAuditDatasetFromRequest(ChPpqAuditDataset auditDataset, Object requestObject, Map<String, Object> parameters) {
        XACMLPolicyQueryType request = (XACMLPolicyQueryType)requestObject;
        auditDataset.setAction(EventActionCode.Execute);
        auditDataset.setQueryId(request.getID());
        Xacml20Utils.extractPatientId(request).ifPresent(auditDataset::setPatientId);
        Xacml20Utils.extractPolicyId(request).ifPresent(id -> auditDataset.getPolicyAndPolicySetIds().add(id.getValue()));
        return auditDataset;
    }

    public boolean enrichAuditDatasetFromResponse(ChPpqAuditDataset auditDataset, Object response, AuditContext auditContext) {
        auditDataset.setEventOutcomeIndicator(this.getEventOutcomeIndicator(auditDataset, response));
        return true;
    }

    public EventOutcomeIndicator getEventOutcomeIndicator(ChPpqAuditDataset auditDataset, Object responseObject) {
        ResponseType response = (ResponseType)responseObject;
        try {
            if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(response.getStatus().getStatusCode().getValue())) {
                return EventOutcomeIndicator.SeriousFailure;
            }
            if (response.getAssertionOrEncryptedAssertion().isEmpty()) {
                return EventOutcomeIndicator.MinorFailure;
            }
            return EventOutcomeIndicator.Success;
        }
        catch (Exception e) {
            return EventOutcomeIndicator.MajorFailure;
        }
    }
}

