/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf.payload;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class WrappedOutputStream
extends FilterOutputStream {
    private final String charsetName;
    private final StringBuilder payloadCollector;
    private boolean isActive;

    public WrappedOutputStream(OutputStream os, String charsetName) {
        super(os);
        this.charsetName = charsetName != null ? charsetName : Charset.defaultCharset().name();
        this.isActive = true;
        this.payloadCollector = new StringBuilder();
    }

    public String getCollectedPayload() {
        return this.payloadCollector.toString();
    }

    public void deactivate() {
        this.isActive = false;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        if (this.isActive) {
            this.payloadCollector.append(new String(b, off, len, this.charsetName));
        }
    }
}

