/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf.audit;

import java.util.ArrayList;
import java.util.List;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;
import org.openehealth.ipf.commons.audit.utils.AuditUtils;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.StringPayloadHolder;

public class WsAuditDataset
extends AuditDataset {
    private static final long serialVersionUID = 7940196804508126576L;
    private String sourceUserId;
    private String destinationUserId;
    private String requestPayload;
    private final List<AuditDataset.HumanUser> humanUsers = new ArrayList<AuditDataset.HumanUser>();
    private String clientIpAddress;
    private PurposeOfUse[] purposesOfUse;
    private String xuaPatientId;
    private String localAddress;
    private String remoteAddress;
    private boolean sourceUserIsRequestor = true;

    public WsAuditDataset(boolean serverSide) {
        super(serverSide);
    }

    public void setRequestPayload(String requestPayload) {
        this.requestPayload = requestPayload;
    }

    public void setRequestPayload(StringPayloadHolder payloadHolder) {
        this.requestPayload = payloadHolder != null ? payloadHolder.get(StringPayloadHolder.PayloadType.SOAP_BODY) : null;
    }

    public String getLocalAddress() {
        return this.localAddress != null ? this.localAddress : AuditUtils.getLocalIPAddress();
    }

    public boolean isSourceUserIsRequestor() {
        return this.sourceUserIsRequestor && super.isSourceUserIsRequestor();
    }

    public String getSourceUserId() {
        return this.sourceUserId;
    }

    public void setSourceUserId(String sourceUserId) {
        this.sourceUserId = sourceUserId;
    }

    public String getDestinationUserId() {
        return this.destinationUserId;
    }

    public void setDestinationUserId(String destinationUserId) {
        this.destinationUserId = destinationUserId;
    }

    public String getRequestPayload() {
        return this.requestPayload;
    }

    public List<AuditDataset.HumanUser> getHumanUsers() {
        return this.humanUsers;
    }

    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    public void setClientIpAddress(String clientIpAddress) {
        this.clientIpAddress = clientIpAddress;
    }

    public PurposeOfUse[] getPurposesOfUse() {
        return this.purposesOfUse;
    }

    public void setPurposesOfUse(PurposeOfUse[] purposesOfUse) {
        this.purposesOfUse = purposesOfUse;
    }

    public String getXuaPatientId() {
        return this.xuaPatientId;
    }

    public void setXuaPatientId(String xuaPatientId) {
        this.xuaPatientId = xuaPatientId;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setSourceUserIsRequestor(boolean sourceUserIsRequestor) {
        this.sourceUserIsRequestor = sourceUserIsRequestor;
    }
}

