/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.ws.InterceptorUtils;
import org.openehealth.ipf.commons.ihe.ws.WsSecurityInformation;
import org.openehealth.ipf.commons.ihe.ws.WsTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.ws.correlation.AsynchronyCorrelator;
import org.openehealth.ipf.commons.ihe.ws.cxf.Cxf3791WorkaroundInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.FixContentTypeOutInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.MustUnderstandDecoratorInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.ProvidedAttachmentOutInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.OutPayloadExtractorInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.OutStreamSubstituteInterceptor;
import org.openehealth.ipf.commons.ihe.ws.utils.SoapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.objectpool.ConcurrentPool;
import org.vibur.objectpool.PoolObjectFactory;
import org.vibur.objectpool.PoolService;
import org.vibur.objectpool.util.ConcurrentCollection;
import org.vibur.objectpool.util.ConcurrentLinkedQueueCollection;

public class JaxWsClientFactory<AuditDatasetType extends WsAuditDataset> {
    private static final Logger LOG = LoggerFactory.getLogger(JaxWsClientFactory.class);
    public static final String POOL_SIZE_PROPERTY = JaxWsClientFactory.class.getName() + ".POOLSIZE";
    private static final int DEFAULT_POOL_SIZE = 100;
    protected final PoolService<Object> clientPool;
    protected final WsTransactionConfiguration<AuditDatasetType> wsTransactionConfiguration;
    protected final String serviceUrl;
    protected final InterceptorProvider customInterceptors;
    protected final List<AbstractFeature> features;
    protected final Map<String, Object> properties;
    protected final AuditStrategy<AuditDatasetType> auditStrategy;
    protected final AuditContext auditContext;
    protected final AsynchronyCorrelator<AuditDatasetType> correlator;
    protected final WsSecurityInformation securityInformation;
    protected final HTTPClientPolicy httpClientPolicy;

    public JaxWsClientFactory(WsTransactionConfiguration<AuditDatasetType> wsTransactionConfiguration, String serviceUrl, AuditStrategy<AuditDatasetType> auditStrategy, AuditContext auditContext, InterceptorProvider customInterceptors, List<AbstractFeature> features, Map<String, Object> properties, AsynchronyCorrelator<AuditDatasetType> correlator, WsSecurityInformation securityInformation, HTTPClientPolicy httpClientPolicy) {
        Objects.requireNonNull(wsTransactionConfiguration, "wsTransactionConfiguration");
        this.wsTransactionConfiguration = wsTransactionConfiguration;
        this.serviceUrl = serviceUrl;
        this.auditStrategy = auditStrategy;
        this.auditContext = auditContext;
        this.customInterceptors = customInterceptors;
        this.features = features;
        this.properties = properties;
        this.correlator = correlator;
        this.securityInformation = securityInformation;
        this.httpClientPolicy = httpClientPolicy;
        int poolSize = Integer.getInteger(POOL_SIZE_PROPERTY, -1);
        this.clientPool = new ConcurrentPool((ConcurrentCollection)new ConcurrentLinkedQueueCollection(), (PoolObjectFactory)new PortFactory(), 0, poolSize > 0 ? poolSize : 100, false);
    }

    public synchronized Object getClient() {
        return this.clientPool.take();
    }

    public WsTransactionConfiguration<AuditDatasetType> getWsTransactionConfiguration() {
        return this.wsTransactionConfiguration;
    }

    protected void configureInterceptors(Client client) {
        client.getInInterceptors().add(new Cxf3791WorkaroundInterceptor());
        if (this.wsTransactionConfiguration.isAddressing()) {
            MustUnderstandDecoratorInterceptor interceptor = new MustUnderstandDecoratorInterceptor();
            for (String nsUri : SoapUtils.WS_ADDRESSING_NS_URIS) {
                interceptor.addHeader(new QName(nsUri, "Action"));
            }
            client.getOutInterceptors().add(interceptor);
            MAPCodec mapCodec = new MAPCodec();
            MAPAggregator mapAggregator = new MAPAggregator();
            client.getInInterceptors().add(mapCodec);
            client.getInInterceptors().add(mapAggregator);
            client.getInFaultInterceptors().add(mapCodec);
            client.getInFaultInterceptors().add(mapAggregator);
            client.getOutInterceptors().add(mapCodec);
            client.getOutInterceptors().add(mapAggregator);
            client.getOutFaultInterceptors().add(mapCodec);
            client.getOutFaultInterceptors().add(mapAggregator);
        }
        if (this.wsTransactionConfiguration.isSwaOutSupport()) {
            client.getOutInterceptors().add(new ProvidedAttachmentOutInterceptor());
            client.getOutInterceptors().add(new FixContentTypeOutInterceptor());
        }
        if (this.features != null) {
            for (AbstractFeature feature : this.features) {
                client.getEndpoint().getActiveFeatures().add(feature);
                feature.initialize(client, client.getBus());
            }
        }
        InterceptorUtils.copyInterceptorsFromProvider(this.customInterceptors, (InterceptorProvider)client);
    }

    protected void configureProperties(Client client) {
        if (this.properties != null) {
            client.getEndpoint().putAll(this.properties);
        }
    }

    protected static void installPayloadInterceptors(Client client) {
        client.getOutInterceptors().add(new OutStreamSubstituteInterceptor());
        client.getOutInterceptors().add(new OutPayloadExtractorInterceptor());
    }

    private void configureBinding(Object port) {
        BindingProvider bindingProvider = (BindingProvider)port;
        Map reqContext = bindingProvider.getRequestContext();
        reqContext.put("javax.xml.ws.service.endpoint.address", this.serviceUrl);
        Binding binding = bindingProvider.getBinding();
        SOAPBinding soapBinding = (SOAPBinding)binding;
        soapBinding.setMTOMEnabled(this.wsTransactionConfiguration.isMtom());
    }

    public void restoreClient(Object client) {
        if (client != null) {
            ClientProxy.getClient((Object)client).getResponseContext().clear();
            this.clientPool.restore(client);
            LOG.debug("Returned client stub {} to the pool", client);
        }
    }

    class PortFactory
    implements PoolObjectFactory<Object> {
        PortFactory() {
        }

        public Object create() {
            URL wsdlURL = this.getClass().getClassLoader().getResource(JaxWsClientFactory.this.wsTransactionConfiguration.getWsdlLocation());
            Service service = Service.create((URL)wsdlURL, (QName)JaxWsClientFactory.this.wsTransactionConfiguration.getServiceName());
            Object port = service.getPort(JaxWsClientFactory.this.wsTransactionConfiguration.getSei());
            Client client = ClientProxy.getClient((Object)port);
            JaxWsClientFactory.this.configureBinding(port);
            JaxWsClientFactory.this.configureInterceptors(client);
            JaxWsClientFactory.this.configureProperties(client);
            if (JaxWsClientFactory.this.securityInformation != null) {
                JaxWsClientFactory.this.securityInformation.configureHttpConduit((HTTPConduit)client.getConduit());
            }
            if (JaxWsClientFactory.this.httpClientPolicy != null) {
                ((HTTPConduit)client.getConduit()).setClient(JaxWsClientFactory.this.httpClientPolicy);
            }
            LOG.debug("Created client stub {} for {}", port, (Object)JaxWsClientFactory.this.wsTransactionConfiguration.getServiceName());
            return port;
        }

        public boolean readyToTake(Object o) {
            return true;
        }

        public boolean readyToRestore(Object o) {
            return true;
        }

        public void destroy(Object o) {
        }
    }
}

