/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf.payload;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.InNamespaceMergeInterceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class InNamespaceMergeInterceptorTest {
    private static DocumentBuilder builder;
    private static final String SOAP_STRING = "<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:urn=\"urn:hl7-org:v3\" myattribute=\"12345\" xmlns:ns3=\"urn:ihe\" xmlns:xmlnsqq=\"urn:dummy:xmlnsns\" xmlnsqq:kpss=\"abcd\"> <soap:Header/> <soap:Body xmlns:ns3=\"body-ns3\" xmlns:internal=\"internal\">garbage</soap:Body> </soap:Envelope>";
    private static Document SOURCE;

    @BeforeClass
    public static void setUpClass() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        builder = factory.newDocumentBuilder();
        SOURCE = InNamespaceMergeInterceptorTest.parse(SOAP_STRING);
    }

    private static Document parse(String document) throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(document.getBytes());
        return builder.parse(stream);
    }

    private static Map<String, String> merge(String payload) throws Exception {
        String target = InNamespaceMergeInterceptor.enrichNamespaces((Document)SOURCE, (String)payload);
        Element element = InNamespaceMergeInterceptorTest.parse(target).getDocumentElement();
        HashMap<String, String> result = new HashMap<String, String>();
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(attribute.getNamespaceURI())) continue;
            result.put(attribute.getLocalName(), attribute.getTextContent());
        }
        return result;
    }

    @Test
    public void testMergeNamespaces() throws Exception {
        Map<String, String> prefixes = InNamespaceMergeInterceptorTest.merge("<element/>");
        Assert.assertTrue((prefixes.size() == 5 ? 1 : 0) != 0);
        prefixes = InNamespaceMergeInterceptorTest.merge("<element>garbage</element>");
        Assert.assertTrue((prefixes.size() == 5 ? 1 : 0) != 0);
        prefixes = InNamespaceMergeInterceptorTest.merge("<element xmlns:soap=\"12345\">garbage</element>");
        Assert.assertTrue((prefixes.size() == 5 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"12345", (Object)prefixes.get("soap"));
        prefixes = InNamespaceMergeInterceptorTest.merge("<element xmlns:xmlns1=\"uri\" xmlns1:soap=\"12345\">garbage</element>");
        Assert.assertTrue((prefixes.size() == 6 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"http://www.w3.org/2003/05/soap-envelope", (Object)prefixes.get("soap"));
        prefixes = InNamespaceMergeInterceptorTest.merge("<element xmlns:internal=\"uri\">garbage</element>");
        Assert.assertTrue((prefixes.size() == 5 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"uri", (Object)prefixes.get("internal"));
        Assert.assertEquals((Object)"body-ns3", (Object)prefixes.get("ns3"));
    }
}

