/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.correlation;

import java.io.Serializable;
import java.util.Objects;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.openehealth.ipf.commons.ihe.ws.correlation.AsynchronyCorrelator;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;

public class EhcacheAsynchronyCorrelator<AuditDatasetType extends WsAuditDataset>
implements AsynchronyCorrelator<AuditDatasetType> {
    private static final String SERVICE_ENDPOINT_URI_SUFFIX = ".serviceEndpoint";
    private static final String CORRELATION_KEY_SUFFIX = ".correlationKey";
    private static final String AUDIT_DATASET_SUFFIX = ".auditDataset";
    private static final String ALTERNATIVE_KEY_SUFFIX = ".alternativeKey";
    private static final String ALTERNATIVE_KEYS_SUFFIX = ".alternativeKeys";
    private final Ehcache ehcache;

    public EhcacheAsynchronyCorrelator(Ehcache ehcache) {
        this.ehcache = Objects.requireNonNull(ehcache, "ehcache instance");
    }

    private void put(String key, String suffix, Serializable value) {
        this.ehcache.put(new Element((Serializable)((Object)(key + suffix)), value));
    }

    private <T extends Serializable> T get(String key, String suffix) {
        Element element = this.ehcache.get((Serializable)((Object)(key + suffix)));
        return (T)(element != null ? (Serializable)element.getObjectValue() : null);
    }

    @Override
    public void storeServiceEndpointUri(String messageId, String serviceEndpointUri) {
        this.put(messageId, SERVICE_ENDPOINT_URI_SUFFIX, (Serializable)((Object)Objects.requireNonNull(serviceEndpointUri, "service endpoint URI")));
    }

    @Override
    public void storeCorrelationKey(String messageId, String correlationKey) {
        this.put(messageId, CORRELATION_KEY_SUFFIX, (Serializable)((Object)Objects.requireNonNull(correlationKey, "correlation key")));
    }

    @Override
    public void storeAuditDataset(String messageId, WsAuditDataset auditDataset) {
        this.put(messageId, AUDIT_DATASET_SUFFIX, (Serializable)((Object)Objects.requireNonNull(auditDataset, "audit dataset")));
    }

    @Override
    public String getServiceEndpointUri(String messageId) {
        return (String)this.get(messageId, SERVICE_ENDPOINT_URI_SUFFIX);
    }

    @Override
    public String getCorrelationKey(String messageId) {
        return (String)this.get(messageId, CORRELATION_KEY_SUFFIX);
    }

    @Override
    public AuditDatasetType getAuditDataset(String messageId) {
        return (AuditDatasetType)((Object)((WsAuditDataset)((Object)this.get(messageId, AUDIT_DATASET_SUFFIX))));
    }

    @Override
    public void storeAlternativeKeys(String messageId, String ... alternativeKeys) {
        Objects.requireNonNull(alternativeKeys, "alternative keys should be not null");
        for (String key : alternativeKeys) {
            this.put(key, ALTERNATIVE_KEY_SUFFIX, (Serializable)((Object)messageId));
        }
        this.put(messageId, ALTERNATIVE_KEYS_SUFFIX, (Serializable)alternativeKeys);
    }

    @Override
    public String getMessageId(String alternativeKey) {
        return (String)this.get(alternativeKey, ALTERNATIVE_KEY_SUFFIX);
    }

    @Override
    public boolean delete(String messageId) {
        String[] alternativeKeys = (String[])this.get(messageId, ALTERNATIVE_KEYS_SUFFIX);
        if (alternativeKeys != null) {
            for (String key : alternativeKeys) {
                this.ehcache.remove((Serializable)((Object)(key + ALTERNATIVE_KEY_SUFFIX)));
            }
        }
        this.ehcache.remove((Serializable)((Object)(messageId + ALTERNATIVE_KEYS_SUFFIX)));
        this.ehcache.remove((Serializable)((Object)(messageId + CORRELATION_KEY_SUFFIX)));
        this.ehcache.remove((Serializable)((Object)(messageId + AUDIT_DATASET_SUFFIX)));
        return this.ehcache.remove((Serializable)((Object)(messageId + SERVICE_ENDPOINT_URI_SUFFIX)));
    }
}

