/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws;

import java.util.Objects;
import javax.xml.namespace.QName;
import org.openehealth.ipf.commons.ihe.core.TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;

public class WsTransactionConfiguration<T extends WsAuditDataset>
extends TransactionConfiguration<T> {
    private final QName bindingName;
    private final Class<?> sei;
    private final QName serviceName;
    private final String wsdlLocation;
    private final boolean mtom;
    private final boolean addressing;
    private final boolean swaOutSupport;
    private final boolean auditRequestPayload;
    private final boolean allowAsynchrony;

    public WsTransactionConfiguration(String name, String description, boolean isQuery, AuditStrategy<T> clientAuditStrategy, AuditStrategy<T> serverAuditStrategy, QName serviceName, Class<?> sei, QName bindingName, boolean mtom, String wsdlLocation, boolean addressing, boolean swaOutSupport, boolean auditRequestPayload, boolean allowAsynchrony) {
        super(name, description, isQuery, clientAuditStrategy, serverAuditStrategy);
        Objects.requireNonNull(serviceName, "serviceName");
        Objects.requireNonNull(sei, "service endpoint interface");
        Objects.requireNonNull(bindingName, "bindingName");
        Objects.requireNonNull(wsdlLocation, "wsdlLocation");
        this.sei = sei;
        this.serviceName = serviceName;
        this.bindingName = bindingName;
        this.mtom = mtom;
        this.wsdlLocation = wsdlLocation;
        this.addressing = addressing;
        this.swaOutSupport = swaOutSupport;
        this.auditRequestPayload = auditRequestPayload;
        this.allowAsynchrony = allowAsynchrony;
    }

    public QName getBindingName() {
        return this.bindingName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public Class<?> getSei() {
        return this.sei;
    }

    public boolean isMtom() {
        return this.mtom;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public boolean isAddressing() {
        return this.addressing;
    }

    public boolean isSwaOutSupport() {
        return this.swaOutSupport;
    }

    public boolean isAuditRequestPayload() {
        return this.auditRequestPayload;
    }

    public boolean isAllowAsynchrony() {
        return this.allowAsynchrony;
    }
}

