/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws;

import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.ws.JaxWsServiceFactory;
import org.openehealth.ipf.commons.ihe.ws.WsTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.ws.cxf.WsRejectionHandlingStrategy;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.AuditInRequestInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.AuditResponseInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.InPayloadExtractorInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.StringPayloadHolder;

public class JaxWsRequestServiceFactory<AuditDatasetType extends WsAuditDataset>
extends JaxWsServiceFactory<AuditDatasetType> {
    public JaxWsRequestServiceFactory(WsTransactionConfiguration<AuditDatasetType> wsTransactionConfiguration, String serviceAddress, AuditStrategy<AuditDatasetType> auditStrategy, AuditContext auditContext, InterceptorProvider customInterceptors, WsRejectionHandlingStrategy rejectionHandlingStrategy) {
        super(wsTransactionConfiguration, serviceAddress, auditStrategy, auditContext, customInterceptors, rejectionHandlingStrategy);
    }

    @Override
    protected void configureInterceptors(ServerFactoryBean svrFactory) {
        super.configureInterceptors(svrFactory);
        if (this.auditStrategy != null) {
            if (this.wsTransactionConfiguration.isAuditRequestPayload()) {
                svrFactory.getInInterceptors().add(new InPayloadExtractorInterceptor(StringPayloadHolder.PayloadType.SOAP_BODY));
            }
            svrFactory.getInInterceptors().add(new AuditInRequestInterceptor(this.auditStrategy, this.auditContext, this.wsTransactionConfiguration));
            AuditResponseInterceptor auditInterceptor = new AuditResponseInterceptor(this.auditStrategy, this.auditContext, true, null, false);
            svrFactory.getOutInterceptors().add(auditInterceptor);
            svrFactory.getOutFaultInterceptors().add(auditInterceptor);
        }
    }
}

