/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.ws.InterceptorUtils;
import org.openehealth.ipf.commons.ihe.ws.WsSecurityInformation;
import org.openehealth.ipf.commons.ihe.ws.WsTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.ws.correlation.AsynchronyCorrelator;
import org.openehealth.ipf.commons.ihe.ws.cxf.Cxf3791WorkaroundInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.FixContentTypeOutInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.MustUnderstandDecoratorInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.ProvidedAttachmentOutInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.OutPayloadExtractorInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.OutStreamSubstituteInterceptor;
import org.openehealth.ipf.commons.ihe.ws.utils.SoapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxWsClientFactory<AuditDatasetType extends WsAuditDataset> {
    private static final Logger LOG = LoggerFactory.getLogger(JaxWsClientFactory.class);
    protected final ThreadLocal<Object> threadLocalPort = new ThreadLocal();
    protected final WsTransactionConfiguration<AuditDatasetType> wsTransactionConfiguration;
    protected final String serviceUrl;
    protected final InterceptorProvider customInterceptors;
    protected final List<AbstractFeature> features;
    protected final Map<String, Object> properties;
    protected final AuditStrategy<AuditDatasetType> auditStrategy;
    protected final AuditContext auditContext;
    protected final AsynchronyCorrelator<AuditDatasetType> correlator;

    public JaxWsClientFactory(WsTransactionConfiguration<AuditDatasetType> wsTransactionConfiguration, String serviceUrl, AuditStrategy<AuditDatasetType> auditStrategy, AuditContext auditContext, InterceptorProvider customInterceptors, List<AbstractFeature> features, Map<String, Object> properties, AsynchronyCorrelator<AuditDatasetType> correlator) {
        Objects.requireNonNull(wsTransactionConfiguration, "wsTransactionConfiguration");
        this.wsTransactionConfiguration = wsTransactionConfiguration;
        this.serviceUrl = serviceUrl;
        this.auditStrategy = auditStrategy;
        this.auditContext = auditContext;
        this.customInterceptors = customInterceptors;
        this.features = features;
        this.properties = properties;
        this.correlator = correlator;
    }

    public synchronized Object getClient(Supplier<WsSecurityInformation> securityInformationSupplier) {
        if (this.threadLocalPort.get() == null) {
            URL wsdlURL = this.getClass().getClassLoader().getResource(this.wsTransactionConfiguration.getWsdlLocation());
            Service service = Service.create((URL)wsdlURL, (QName)this.wsTransactionConfiguration.getServiceName());
            Object port = service.getPort(this.wsTransactionConfiguration.getSei());
            Client client = ClientProxy.getClient((Object)port);
            this.configureBinding(port);
            this.configureInterceptors(client);
            this.configureProperties(client);
            WsSecurityInformation securityInformation = securityInformationSupplier.get();
            if (securityInformation != null) {
                securityInformation.configureHttpConduit((HTTPConduit)client.getConduit());
            }
            this.threadLocalPort.set(port);
            LOG.debug("Created client adapter for: {}", (Object)this.wsTransactionConfiguration.getServiceName());
        }
        return this.threadLocalPort.get();
    }

    public synchronized Object getClient() {
        return this.getClient(() -> null);
    }

    public WsTransactionConfiguration<AuditDatasetType> getWsTransactionConfiguration() {
        return this.wsTransactionConfiguration;
    }

    protected void configureInterceptors(Client client) {
        client.getInInterceptors().add(new Cxf3791WorkaroundInterceptor());
        if (this.wsTransactionConfiguration.isAddressing()) {
            MustUnderstandDecoratorInterceptor interceptor = new MustUnderstandDecoratorInterceptor();
            for (String nsUri : SoapUtils.WS_ADDRESSING_NS_URIS) {
                interceptor.addHeader(new QName(nsUri, "Action"));
            }
            client.getOutInterceptors().add(interceptor);
            MAPCodec mapCodec = new MAPCodec();
            MAPAggregator mapAggregator = new MAPAggregator();
            client.getInInterceptors().add(mapCodec);
            client.getInInterceptors().add(mapAggregator);
            client.getInFaultInterceptors().add(mapCodec);
            client.getInFaultInterceptors().add(mapAggregator);
            client.getOutInterceptors().add(mapCodec);
            client.getOutInterceptors().add(mapAggregator);
            client.getOutFaultInterceptors().add(mapCodec);
            client.getOutFaultInterceptors().add(mapAggregator);
        }
        if (this.wsTransactionConfiguration.isSwaOutSupport()) {
            client.getOutInterceptors().add(new ProvidedAttachmentOutInterceptor());
            client.getOutInterceptors().add(new FixContentTypeOutInterceptor());
        }
        if (this.features != null) {
            for (AbstractFeature feature : this.features) {
                client.getEndpoint().getActiveFeatures().add(feature);
                feature.initialize(client, client.getBus());
            }
        }
        InterceptorUtils.copyInterceptorsFromProvider(this.customInterceptors, (InterceptorProvider)client);
    }

    protected void configureProperties(Client client) {
        if (this.properties != null) {
            client.getEndpoint().putAll(this.properties);
        }
    }

    protected static void installPayloadInterceptors(Client client) {
        client.getOutInterceptors().add(new OutStreamSubstituteInterceptor());
        client.getOutInterceptors().add(new OutPayloadExtractorInterceptor());
    }

    private void configureBinding(Object port) {
        BindingProvider bindingProvider = (BindingProvider)port;
        Map reqContext = bindingProvider.getRequestContext();
        reqContext.put("javax.xml.ws.service.endpoint.address", this.serviceUrl);
        Binding binding = bindingProvider.getBinding();
        SOAPBinding soapBinding = (SOAPBinding)binding;
        soapBinding.setMTOMEnabled(this.wsTransactionConfiguration.isMtom());
    }
}

