/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws;

import java.util.List;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;

public abstract class InterceptorUtils {
    private InterceptorUtils() {
        throw new IllegalStateException("Cannot instantiate utility class");
    }

    public static void copyInterceptorsFromProvider(InterceptorProvider source, InterceptorProvider target) {
        if (source != null) {
            InterceptorUtils.copyInterceptorsFromList(source.getInInterceptors(), target.getInInterceptors());
            InterceptorUtils.copyInterceptorsFromList(source.getInFaultInterceptors(), target.getInFaultInterceptors());
            InterceptorUtils.copyInterceptorsFromList(source.getOutInterceptors(), target.getOutInterceptors());
            InterceptorUtils.copyInterceptorsFromList(source.getOutFaultInterceptors(), target.getOutFaultInterceptors());
        }
    }

    private static void copyInterceptorsFromList(List<Interceptor<? extends Message>> source, List<Interceptor<? extends Message>> target) {
        if (source != null) {
            target.addAll(source);
        }
    }

    public static <T> T findContextualProperty(Message message, String propertyName) {
        Message[] messages;
        Exchange exchange = message.getExchange();
        for (Message m : messages = new Message[]{message, exchange.getInMessage(), exchange.getOutMessage(), exchange.getInFaultMessage(), exchange.getOutFaultMessage()}) {
            Object t;
            if (m == null || (t = m.getContextualProperty(propertyName)) == null) continue;
            return (T)t;
        }
        return null;
    }
}

