/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.junit.Assert;
import org.junit.Test;
import org.openehealth.ipf.commons.ihe.ws.server.JettyServer;
import org.openehealth.ipf.commons.ihe.ws.server.ServletServer;
import org.openehealth.ipf.commons.ihe.ws.server.TomcatServer;

public class TestServers {
    @Test
    public void testTomcat() throws Exception {
        this.checkServer(new TomcatServer(), 9090);
    }

    @Test
    public void testJetty() throws Exception {
        this.checkServer(new JettyServer(), 9091);
    }

    private void checkServer(ServletServer server, int port) throws Exception {
        URL contextResource = this.getClass().getResource("/test.xml");
        server.setServlet((javax.servlet.Servlet)new Servlet());
        server.setPort(port);
        server.setContextPath("/testContext");
        server.setServletPath("/testServlet/*");
        server.setContextResource(contextResource.toURI().toString());
        server.start();
        this.checkPostRequest(port);
        server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPostRequest(int port) throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost method = new HttpPost("http://localhost:" + port + "/testContext/testServlet/bla");
        method.setEntity((HttpEntity)new StringEntity("hello world"));
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            HttpResponse response = client.execute((HttpUriRequest)method);
            response.getEntity().writeTo((OutputStream)stream);
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"hello world", (Object)new String(stream.toByteArray()));
        }
        finally {
            method.releaseConnection();
        }
    }

    public static class Servlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)response.getOutputStream());
        }
    }
}

