/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.utils;

import org.junit.Assert;
import org.junit.Test;
import org.openehealth.ipf.commons.ihe.ws.utils.SoapUtils;

public class TestSoapUtils {
    private final String contents = "<ns2:ImportantQuestion>Camel rules as cigarettes as well.  Do Apache Indians smoke it?</ns2:ImportantQuestion>";
    private final String envelopeWithNamespacePrefixes = "<soap:Envelope><soap:Header>    <thirdns:header value=\"12345\">some text</thirdns:header></soap:Header>    <soap:Body><ns2:ImportantQuestion>Camel rules as cigarettes as well.  Do Apache Indians smoke it?</ns2:ImportantQuestion></soap:Body></soap:Envelope>";
    private final String envelopeWithoutNamespacePrefixes = "<Envelope><Header>    <thirdns:header value=\"12345\">some text</thirdns:header></Header>    <Body><ns2:ImportantQuestion>Camel rules as cigarettes as well.  Do Apache Indians smoke it?</ns2:ImportantQuestion></Body></Envelope>";
    private final String emptyEnvelopeWithNamespacePrefixes = "<soap:Envelope><soap:Header>    <thirdns:header value=\"12345\">some text</thirdns:header></soap:Header>    <soap:Body xmlns:prefix=\"uri\"></soap:Body></soap:Envelope>";
    private final String emptyEnvelopeWithoutNamespacePrefixes = "<Envelope><Header>    <thirdns:header value=\"12345\">some text</thirdns:header></Header>    <Body></Body></Envelope>";
    private final String emptyEnvelopeWithNamespacePrefixesShort = "<soap:Envelope><soap:Header>    <thirdns:header value=\"12345\">some text</thirdns:header></soap:Header>    <soap:Body attrib=\"value\" /></soap:Envelope>";
    private final String emptyEnvelopeWithoutNamespacePrefixesShort = "<Envelope><Header>    <thirdns:header value=\"12345\">some text</thirdns:header></Header>    <Body /></Envelope>";
    private final String totallyBad = "12345";

    @Test
    public void testExctractSoapBody() {
        Assert.assertEquals((Object)"<ns2:ImportantQuestion>Camel rules as cigarettes as well.  Do Apache Indians smoke it?</ns2:ImportantQuestion>", (Object)SoapUtils.extractSoapBody((String)"<soap:Envelope><soap:Header>    <thirdns:header value=\"12345\">some text</thirdns:header></soap:Header>    <soap:Body><ns2:ImportantQuestion>Camel rules as cigarettes as well.  Do Apache Indians smoke it?</ns2:ImportantQuestion></soap:Body></soap:Envelope>"));
        Assert.assertEquals((Object)"<ns2:ImportantQuestion>Camel rules as cigarettes as well.  Do Apache Indians smoke it?</ns2:ImportantQuestion>", (Object)SoapUtils.extractSoapBody((String)"<Envelope><Header>    <thirdns:header value=\"12345\">some text</thirdns:header></Header>    <Body><ns2:ImportantQuestion>Camel rules as cigarettes as well.  Do Apache Indians smoke it?</ns2:ImportantQuestion></Body></Envelope>"));
        Assert.assertEquals((Object)"", (Object)SoapUtils.extractSoapBody((String)"<soap:Envelope><soap:Header>    <thirdns:header value=\"12345\">some text</thirdns:header></soap:Header>    <soap:Body xmlns:prefix=\"uri\"></soap:Body></soap:Envelope>"));
        Assert.assertEquals((Object)"", (Object)SoapUtils.extractSoapBody((String)"<Envelope><Header>    <thirdns:header value=\"12345\">some text</thirdns:header></Header>    <Body></Body></Envelope>"));
        Assert.assertEquals((Object)"", (Object)SoapUtils.extractSoapBody((String)"<soap:Envelope><soap:Header>    <thirdns:header value=\"12345\">some text</thirdns:header></soap:Header>    <soap:Body attrib=\"value\" /></soap:Envelope>"));
        Assert.assertEquals((Object)"", (Object)SoapUtils.extractSoapBody((String)"<Envelope><Header>    <thirdns:header value=\"12345\">some text</thirdns:header></Header>    <Body /></Envelope>"));
        Assert.assertNull((Object)SoapUtils.extractSoapBody(null));
        Assert.assertEquals((Object)"12345", (Object)SoapUtils.extractSoapBody((String)"12345"));
    }
}

