/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.server;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.message.config.AuthConfigFactory;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.jaspic.AuthConfigFactoryImpl;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.openehealth.ipf.commons.ihe.core.ClientAuthType;
import org.openehealth.ipf.commons.ihe.ws.server.ServletServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ContextLoaderListener;

public class TomcatServer
extends ServletServer {
    private static final Logger log = LoggerFactory.getLogger(TomcatServer.class);
    private static final AtomicInteger SERVLET_COUNTER = new AtomicInteger(0);
    private Tomcat embedded;
    private Wrapper wrapper;

    @Override
    public void start() {
        this.embedded = new Tomcat();
        AuthConfigFactory.setFactory((AuthConfigFactory)new AuthConfigFactoryImpl());
        Context context = this.embedded.addContext(this.getContextPath(), "/");
        context.addParameter("contextConfigLocation", this.getContextResource());
        context.addApplicationListener(ContextLoaderListener.class.getName());
        this.embedded.getHost().setAppBase("");
        String servletName = this.getServletName() == null ? "ipf-servlet-" + SERVLET_COUNTER.getAndIncrement() : this.getServletName();
        this.wrapper = context.createWrapper();
        this.wrapper.setName(servletName);
        this.wrapper.setServletClass(this.getServlet().getClass().getName());
        for (Map.Entry<String, String> parameters : this.getInitParameters().entrySet()) {
            this.wrapper.addInitParameter(parameters.getKey(), parameters.getValue());
        }
        context.addChild((Container)this.wrapper);
        context.addServletMapping(this.getServletPath(), servletName);
        Connector connector = this.embedded.getConnector();
        connector.setPort(this.getPort());
        if (this.isSecure()) {
            connector.setSecure(true);
            connector.setScheme("https");
            connector.setProperty("SSLEnabled", "true");
            connector.setProperty("sslProtocol", "TLS");
            connector.setProperty("keystoreFile", this.getKeystoreFile());
            connector.setProperty("keystorePass", this.getKeystorePass());
            connector.setProperty("truststoreFile", this.getTruststoreFile());
            connector.setProperty("truststorePass", this.getTruststorePass());
            if (this.getClientAuthType() == ClientAuthType.MUST) {
                connector.setProperty("clientAuth", "true");
            } else if (this.getClientAuthType() == ClientAuthType.WANT) {
                connector.setProperty("clientAuth", "want");
            }
        }
        try {
            this.embedded.start();
            this.wrapper.allocate();
            log.info("Started embedded Tomcat server");
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void stop() {
        if (this.embedded != null) {
            try {
                this.wrapper.deallocate(this.getServlet());
                this.embedded.stop();
                log.info("Stopped embedded Tomcat server");
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

