/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.servlet.Servlet;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.core.ClientAuthType;

public abstract class ServletServer {
    private Servlet servlet;
    private String servletName;
    private int port;
    private String contextPath;
    private String servletPath;
    private String contextResource;
    private boolean secure;
    private String keystoreFile;
    private String keystorePass;
    private String truststoreFile;
    private String truststorePass;
    private Map<String, String> initParameters = new HashMap<String, String>();
    private ClientAuthType clientAuthType;

    public abstract void start();

    public abstract void stop();

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public void setServletPath(String servletPath) {
        Validate.notNull((Object)servletPath, (String)"servletPath cannot be null", (Object[])new Object[0]);
        this.servletPath = servletPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setContextPath(String contextPath) {
        Validate.notNull((Object)contextPath, (String)"contextPath cannot be null", (Object[])new Object[0]);
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setServlet(Servlet servlet) {
        Validate.notNull((Object)servlet, (String)"servlet cannot be null", (Object[])new Object[0]);
        this.servlet = servlet;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public String getTruststoreFile() {
        return this.truststoreFile;
    }

    public void setTruststoreFile(String truststoreFile) {
        this.truststoreFile = truststoreFile;
    }

    public String getTruststorePass() {
        return this.truststorePass;
    }

    public void setTruststorePass(String truststorePass) {
        this.truststorePass = truststorePass;
    }

    public String getContextResource() {
        return this.contextResource;
    }

    public void setContextResource(String contextResource) {
        this.contextResource = contextResource;
    }

    public ClientAuthType getClientAuthType() {
        return this.clientAuthType;
    }

    public void setClientAuthType(ClientAuthType clientAuthType) {
        this.clientAuthType = clientAuthType;
    }

    public static int getFreePort() {
        int port = 8000;
        boolean portFree = false;
        while (!portFree) {
            port = 8000 + new Random().nextInt(2000);
            portFree = ServletServer.isPortFree(port);
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPortFree(int port) {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
    }
}

