/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.server;

import java.util.EventListener;
import java.util.Map;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.openehealth.ipf.commons.ihe.core.ClientAuthType;
import org.openehealth.ipf.commons.ihe.ws.server.ServletServer;
import org.springframework.web.context.ContextLoaderListener;

public class JettyServer
extends ServletServer {
    private Server server;

    @Override
    public void start() {
        this.server = new Server();
        ServerConnector connector = this.isSecure() ? new ServerConnector(this.server, this.createSecureContextFactory()) : new ServerConnector(this.server);
        this.server.addConnector((Connector)connector);
        connector.setPort(this.getPort());
        ServletContextHandler context = new ServletContextHandler(0);
        context.setResourceBase("/");
        ContextLoaderListener listener = new ContextLoaderListener();
        context.getInitParams().put("contextConfigLocation", this.getContextResource());
        context.addEventListener((EventListener)listener);
        context.setContextPath(this.getContextPath());
        ServletHolder holder = new ServletHolder(this.getServlet());
        holder.setName(this.getServletName());
        context.addServlet(holder, this.getServletPath());
        for (Map.Entry<String, String> parameters : this.getInitParameters().entrySet()) {
            holder.setInitParameter(parameters.getKey(), parameters.getValue());
        }
        this.server.setHandler((Handler)context);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private SslContextFactory createSecureContextFactory() {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(this.getKeystoreFile());
        sslContextFactory.setKeyStorePassword(this.getKeystorePass());
        sslContextFactory.setTrustStorePath(this.getTruststoreFile());
        sslContextFactory.setTrustStorePassword(this.getTruststorePass());
        sslContextFactory.setNeedClientAuth(this.getClientAuthType() == ClientAuthType.MUST);
        sslContextFactory.setWantClientAuth(this.getClientAuthType() == ClientAuthType.WANT);
        return sslContextFactory;
    }

    @Override
    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

